<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCodeInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfCodeInfo extends AbstractStructArrayBase
{
    /**
     * The CodeInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CodeInfo[]
     */
    public $CodeInfo;
    /**
     * Constructor method for ArrayOfCodeInfo
     * @uses ArrayOfCodeInfo::setCodeInfo()
     * @param \StructType\CodeInfo[] $codeInfo
     */
    public function __construct(array $codeInfo = array())
    {
        $this
            ->setCodeInfo($codeInfo);
    }
    /**
     * Get CodeInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CodeInfo[]|null
     */
    public function getCodeInfo()
    {
        return isset($this->CodeInfo) ? $this->CodeInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCodeInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCodeInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCodeInfoForArrayConstraintsFromSetCodeInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCodeInfoCodeInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfCodeInfoCodeInfoItem instanceof \StructType\CodeInfo) {
                $invalidValues[] = is_object($arrayOfCodeInfoCodeInfoItem) ? get_class($arrayOfCodeInfoCodeInfoItem) : sprintf('%s(%s)', gettype($arrayOfCodeInfoCodeInfoItem), var_export($arrayOfCodeInfoCodeInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CodeInfo property can only contain items of type \StructType\CodeInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CodeInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CodeInfo[] $codeInfo
     * @return \ArrayType\ArrayOfCodeInfo
     */
    public function setCodeInfo(array $codeInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($codeInfoArrayErrorMessage = self::validateCodeInfoForArrayConstraintsFromSetCodeInfo($codeInfo))) {
            throw new \InvalidArgumentException($codeInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($codeInfo) || (is_array($codeInfo) && empty($codeInfo))) {
            unset($this->CodeInfo);
        } else {
            $this->CodeInfo = $codeInfo;
        }
        return $this;
    }
    /**
     * Add item to CodeInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\CodeInfo $item
     * @return \ArrayType\ArrayOfCodeInfo
     */
    public function addToCodeInfo(\StructType\CodeInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CodeInfo) {
            throw new \InvalidArgumentException(sprintf('The CodeInfo property can only contain items of type \StructType\CodeInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CodeInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CodeInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CodeInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CodeInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CodeInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CodeInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CodeInfo
     */
    public function getAttributeName()
    {
        return 'CodeInfo';
    }
}
