<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAnomaly_V4 ArrayType
 * @subpackage Arrays
 */
class ArrayOfAnomaly_V4 extends AbstractStructArrayBase
{
    /**
     * The Anomaly_V4
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Anomaly_V4[]
     */
    public $Anomaly_V4;
    /**
     * Constructor method for ArrayOfAnomaly_V4
     * @uses ArrayOfAnomaly_V4::setAnomaly_V4()
     * @param \StructType\Anomaly_V4[] $anomaly_V4
     */
    public function __construct(array $anomaly_V4 = array())
    {
        $this
            ->setAnomaly_V4($anomaly_V4);
    }
    /**
     * Get Anomaly_V4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Anomaly_V4[]|null
     */
    public function getAnomaly_V4()
    {
        return isset($this->Anomaly_V4) ? $this->Anomaly_V4 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAnomaly_V4 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAnomaly_V4 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAnomaly_V4ForArrayConstraintsFromSetAnomaly_V4(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAnomaly_V4Anomaly_V4Item) {
            // validation for constraint: itemType
            if (!$arrayOfAnomaly_V4Anomaly_V4Item instanceof \StructType\Anomaly_V4) {
                $invalidValues[] = is_object($arrayOfAnomaly_V4Anomaly_V4Item) ? get_class($arrayOfAnomaly_V4Anomaly_V4Item) : sprintf('%s(%s)', gettype($arrayOfAnomaly_V4Anomaly_V4Item), var_export($arrayOfAnomaly_V4Anomaly_V4Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Anomaly_V4 property can only contain items of type \StructType\Anomaly_V4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Anomaly_V4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Anomaly_V4[] $anomaly_V4
     * @return \ArrayType\ArrayOfAnomaly_V4
     */
    public function setAnomaly_V4(array $anomaly_V4 = array())
    {
        // validation for constraint: array
        if ('' !== ($anomaly_V4ArrayErrorMessage = self::validateAnomaly_V4ForArrayConstraintsFromSetAnomaly_V4($anomaly_V4))) {
            throw new \InvalidArgumentException($anomaly_V4ArrayErrorMessage, __LINE__);
        }
        if (is_null($anomaly_V4) || (is_array($anomaly_V4) && empty($anomaly_V4))) {
            unset($this->Anomaly_V4);
        } else {
            $this->Anomaly_V4 = $anomaly_V4;
        }
        return $this;
    }
    /**
     * Add item to Anomaly_V4 value
     * @throws \InvalidArgumentException
     * @param \StructType\Anomaly_V4 $item
     * @return \ArrayType\ArrayOfAnomaly_V4
     */
    public function addToAnomaly_V4(\StructType\Anomaly_V4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Anomaly_V4) {
            throw new \InvalidArgumentException(sprintf('The Anomaly_V4 property can only contain items of type \StructType\Anomaly_V4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Anomaly_V4[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Anomaly_V4|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Anomaly_V4|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Anomaly_V4|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Anomaly_V4|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Anomaly_V4|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Anomaly_V4
     */
    public function getAttributeName()
    {
        return 'Anomaly_V4';
    }
}
