<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAnomaly_V3 ArrayType
 * @subpackage Arrays
 */
class ArrayOfAnomaly_V3 extends AbstractStructArrayBase
{
    /**
     * The Anomaly_V3
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Anomaly_V3[]
     */
    public $Anomaly_V3;
    /**
     * Constructor method for ArrayOfAnomaly_V3
     * @uses ArrayOfAnomaly_V3::setAnomaly_V3()
     * @param \StructType\Anomaly_V3[] $anomaly_V3
     */
    public function __construct(array $anomaly_V3 = array())
    {
        $this
            ->setAnomaly_V3($anomaly_V3);
    }
    /**
     * Get Anomaly_V3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Anomaly_V3[]|null
     */
    public function getAnomaly_V3()
    {
        return isset($this->Anomaly_V3) ? $this->Anomaly_V3 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAnomaly_V3 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAnomaly_V3 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAnomaly_V3ForArrayConstraintsFromSetAnomaly_V3(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAnomaly_V3Anomaly_V3Item) {
            // validation for constraint: itemType
            if (!$arrayOfAnomaly_V3Anomaly_V3Item instanceof \StructType\Anomaly_V3) {
                $invalidValues[] = is_object($arrayOfAnomaly_V3Anomaly_V3Item) ? get_class($arrayOfAnomaly_V3Anomaly_V3Item) : sprintf('%s(%s)', gettype($arrayOfAnomaly_V3Anomaly_V3Item), var_export($arrayOfAnomaly_V3Anomaly_V3Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Anomaly_V3 property can only contain items of type \StructType\Anomaly_V3, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Anomaly_V3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Anomaly_V3[] $anomaly_V3
     * @return \ArrayType\ArrayOfAnomaly_V3
     */
    public function setAnomaly_V3(array $anomaly_V3 = array())
    {
        // validation for constraint: array
        if ('' !== ($anomaly_V3ArrayErrorMessage = self::validateAnomaly_V3ForArrayConstraintsFromSetAnomaly_V3($anomaly_V3))) {
            throw new \InvalidArgumentException($anomaly_V3ArrayErrorMessage, __LINE__);
        }
        if (is_null($anomaly_V3) || (is_array($anomaly_V3) && empty($anomaly_V3))) {
            unset($this->Anomaly_V3);
        } else {
            $this->Anomaly_V3 = $anomaly_V3;
        }
        return $this;
    }
    /**
     * Add item to Anomaly_V3 value
     * @throws \InvalidArgumentException
     * @param \StructType\Anomaly_V3 $item
     * @return \ArrayType\ArrayOfAnomaly_V3
     */
    public function addToAnomaly_V3(\StructType\Anomaly_V3 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Anomaly_V3) {
            throw new \InvalidArgumentException(sprintf('The Anomaly_V3 property can only contain items of type \StructType\Anomaly_V3, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Anomaly_V3[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Anomaly_V3|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Anomaly_V3|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Anomaly_V3|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Anomaly_V3|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Anomaly_V3|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Anomaly_V3
     */
    public function getAttributeName()
    {
        return 'Anomaly_V3';
    }
}
