<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAnomaly ArrayType
 * @subpackage Arrays
 */
class ArrayOfAnomaly extends AbstractStructArrayBase
{
    /**
     * The Anomaly
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Anomaly[]
     */
    public $Anomaly;
    /**
     * Constructor method for ArrayOfAnomaly
     * @uses ArrayOfAnomaly::setAnomaly()
     * @param \StructType\Anomaly[] $anomaly
     */
    public function __construct(array $anomaly = array())
    {
        $this
            ->setAnomaly($anomaly);
    }
    /**
     * Get Anomaly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Anomaly[]|null
     */
    public function getAnomaly()
    {
        return isset($this->Anomaly) ? $this->Anomaly : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAnomaly method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAnomaly method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAnomalyForArrayConstraintsFromSetAnomaly(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAnomalyAnomalyItem) {
            // validation for constraint: itemType
            if (!$arrayOfAnomalyAnomalyItem instanceof \StructType\Anomaly) {
                $invalidValues[] = is_object($arrayOfAnomalyAnomalyItem) ? get_class($arrayOfAnomalyAnomalyItem) : sprintf('%s(%s)', gettype($arrayOfAnomalyAnomalyItem), var_export($arrayOfAnomalyAnomalyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Anomaly property can only contain items of type \StructType\Anomaly, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Anomaly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Anomaly[] $anomaly
     * @return \ArrayType\ArrayOfAnomaly
     */
    public function setAnomaly(array $anomaly = array())
    {
        // validation for constraint: array
        if ('' !== ($anomalyArrayErrorMessage = self::validateAnomalyForArrayConstraintsFromSetAnomaly($anomaly))) {
            throw new \InvalidArgumentException($anomalyArrayErrorMessage, __LINE__);
        }
        if (is_null($anomaly) || (is_array($anomaly) && empty($anomaly))) {
            unset($this->Anomaly);
        } else {
            $this->Anomaly = $anomaly;
        }
        return $this;
    }
    /**
     * Add item to Anomaly value
     * @throws \InvalidArgumentException
     * @param \StructType\Anomaly $item
     * @return \ArrayType\ArrayOfAnomaly
     */
    public function addToAnomaly(\StructType\Anomaly $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Anomaly) {
            throw new \InvalidArgumentException(sprintf('The Anomaly property can only contain items of type \StructType\Anomaly, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Anomaly[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Anomaly|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Anomaly|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Anomaly|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Anomaly|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Anomaly|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Anomaly
     */
    public function getAttributeName()
    {
        return 'Anomaly';
    }
}
