<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfActivityVersionResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfActivityVersionResult extends AbstractStructArrayBase
{
    /**
     * The ActivityVersionResult
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ActivityVersionResult[]
     */
    public $ActivityVersionResult;
    /**
     * Constructor method for ArrayOfActivityVersionResult
     * @uses ArrayOfActivityVersionResult::setActivityVersionResult()
     * @param \StructType\ActivityVersionResult[] $activityVersionResult
     */
    public function __construct(array $activityVersionResult = array())
    {
        $this
            ->setActivityVersionResult($activityVersionResult);
    }
    /**
     * Get ActivityVersionResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ActivityVersionResult[]|null
     */
    public function getActivityVersionResult()
    {
        return isset($this->ActivityVersionResult) ? $this->ActivityVersionResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setActivityVersionResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActivityVersionResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActivityVersionResultForArrayConstraintsFromSetActivityVersionResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfActivityVersionResultActivityVersionResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfActivityVersionResultActivityVersionResultItem instanceof \StructType\ActivityVersionResult) {
                $invalidValues[] = is_object($arrayOfActivityVersionResultActivityVersionResultItem) ? get_class($arrayOfActivityVersionResultActivityVersionResultItem) : sprintf('%s(%s)', gettype($arrayOfActivityVersionResultActivityVersionResultItem), var_export($arrayOfActivityVersionResultActivityVersionResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ActivityVersionResult property can only contain items of type \StructType\ActivityVersionResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ActivityVersionResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityVersionResult[] $activityVersionResult
     * @return \ArrayType\ArrayOfActivityVersionResult
     */
    public function setActivityVersionResult(array $activityVersionResult = array())
    {
        // validation for constraint: array
        if ('' !== ($activityVersionResultArrayErrorMessage = self::validateActivityVersionResultForArrayConstraintsFromSetActivityVersionResult($activityVersionResult))) {
            throw new \InvalidArgumentException($activityVersionResultArrayErrorMessage, __LINE__);
        }
        if (is_null($activityVersionResult) || (is_array($activityVersionResult) && empty($activityVersionResult))) {
            unset($this->ActivityVersionResult);
        } else {
            $this->ActivityVersionResult = $activityVersionResult;
        }
        return $this;
    }
    /**
     * Add item to ActivityVersionResult value
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityVersionResult $item
     * @return \ArrayType\ArrayOfActivityVersionResult
     */
    public function addToActivityVersionResult(\StructType\ActivityVersionResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ActivityVersionResult) {
            throw new \InvalidArgumentException(sprintf('The ActivityVersionResult property can only contain items of type \StructType\ActivityVersionResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ActivityVersionResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ActivityVersionResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ActivityVersionResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ActivityVersionResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ActivityVersionResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ActivityVersionResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ActivityVersionResult
     */
    public function getAttributeName()
    {
        return 'ActivityVersionResult';
    }
}
