<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfActivityReportItem_V9 ArrayType
 * @subpackage Arrays
 */
class ArrayOfActivityReportItem_V9 extends AbstractStructArrayBase
{
    /**
     * The ActivityReportItem_V9
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ActivityReportItem_V9[]
     */
    public $ActivityReportItem_V9;
    /**
     * Constructor method for ArrayOfActivityReportItem_V9
     * @uses ArrayOfActivityReportItem_V9::setActivityReportItem_V9()
     * @param \StructType\ActivityReportItem_V9[] $activityReportItem_V9
     */
    public function __construct(array $activityReportItem_V9 = array())
    {
        $this
            ->setActivityReportItem_V9($activityReportItem_V9);
    }
    /**
     * Get ActivityReportItem_V9 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ActivityReportItem_V9[]|null
     */
    public function getActivityReportItem_V9()
    {
        return isset($this->ActivityReportItem_V9) ? $this->ActivityReportItem_V9 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setActivityReportItem_V9 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActivityReportItem_V9 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActivityReportItem_V9ForArrayConstraintsFromSetActivityReportItem_V9(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfActivityReportItem_V9ActivityReportItem_V9Item) {
            // validation for constraint: itemType
            if (!$arrayOfActivityReportItem_V9ActivityReportItem_V9Item instanceof \StructType\ActivityReportItem_V9) {
                $invalidValues[] = is_object($arrayOfActivityReportItem_V9ActivityReportItem_V9Item) ? get_class($arrayOfActivityReportItem_V9ActivityReportItem_V9Item) : sprintf('%s(%s)', gettype($arrayOfActivityReportItem_V9ActivityReportItem_V9Item), var_export($arrayOfActivityReportItem_V9ActivityReportItem_V9Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ActivityReportItem_V9 property can only contain items of type \StructType\ActivityReportItem_V9, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ActivityReportItem_V9 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityReportItem_V9[] $activityReportItem_V9
     * @return \ArrayType\ArrayOfActivityReportItem_V9
     */
    public function setActivityReportItem_V9(array $activityReportItem_V9 = array())
    {
        // validation for constraint: array
        if ('' !== ($activityReportItem_V9ArrayErrorMessage = self::validateActivityReportItem_V9ForArrayConstraintsFromSetActivityReportItem_V9($activityReportItem_V9))) {
            throw new \InvalidArgumentException($activityReportItem_V9ArrayErrorMessage, __LINE__);
        }
        if (is_null($activityReportItem_V9) || (is_array($activityReportItem_V9) && empty($activityReportItem_V9))) {
            unset($this->ActivityReportItem_V9);
        } else {
            $this->ActivityReportItem_V9 = $activityReportItem_V9;
        }
        return $this;
    }
    /**
     * Add item to ActivityReportItem_V9 value
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityReportItem_V9 $item
     * @return \ArrayType\ArrayOfActivityReportItem_V9
     */
    public function addToActivityReportItem_V9(\StructType\ActivityReportItem_V9 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ActivityReportItem_V9) {
            throw new \InvalidArgumentException(sprintf('The ActivityReportItem_V9 property can only contain items of type \StructType\ActivityReportItem_V9, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ActivityReportItem_V9[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ActivityReportItem_V9|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ActivityReportItem_V9|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ActivityReportItem_V9|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ActivityReportItem_V9|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ActivityReportItem_V9|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ActivityReportItem_V9
     */
    public function getAttributeName()
    {
        return 'ActivityReportItem_V9';
    }
}
