<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfActivityRemark ArrayType
 * @subpackage Arrays
 */
class ArrayOfActivityRemark extends AbstractStructArrayBase
{
    /**
     * The ActivityRemark
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ActivityRemark[]
     */
    public $ActivityRemark;
    /**
     * Constructor method for ArrayOfActivityRemark
     * @uses ArrayOfActivityRemark::setActivityRemark()
     * @param \StructType\ActivityRemark[] $activityRemark
     */
    public function __construct(array $activityRemark = array())
    {
        $this
            ->setActivityRemark($activityRemark);
    }
    /**
     * Get ActivityRemark value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ActivityRemark[]|null
     */
    public function getActivityRemark()
    {
        return isset($this->ActivityRemark) ? $this->ActivityRemark : null;
    }
    /**
     * This method is responsible for validating the values passed to the setActivityRemark method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActivityRemark method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActivityRemarkForArrayConstraintsFromSetActivityRemark(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfActivityRemarkActivityRemarkItem) {
            // validation for constraint: itemType
            if (!$arrayOfActivityRemarkActivityRemarkItem instanceof \StructType\ActivityRemark) {
                $invalidValues[] = is_object($arrayOfActivityRemarkActivityRemarkItem) ? get_class($arrayOfActivityRemarkActivityRemarkItem) : sprintf('%s(%s)', gettype($arrayOfActivityRemarkActivityRemarkItem), var_export($arrayOfActivityRemarkActivityRemarkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ActivityRemark property can only contain items of type \StructType\ActivityRemark, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ActivityRemark value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityRemark[] $activityRemark
     * @return \ArrayType\ArrayOfActivityRemark
     */
    public function setActivityRemark(array $activityRemark = array())
    {
        // validation for constraint: array
        if ('' !== ($activityRemarkArrayErrorMessage = self::validateActivityRemarkForArrayConstraintsFromSetActivityRemark($activityRemark))) {
            throw new \InvalidArgumentException($activityRemarkArrayErrorMessage, __LINE__);
        }
        if (is_null($activityRemark) || (is_array($activityRemark) && empty($activityRemark))) {
            unset($this->ActivityRemark);
        } else {
            $this->ActivityRemark = $activityRemark;
        }
        return $this;
    }
    /**
     * Add item to ActivityRemark value
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityRemark $item
     * @return \ArrayType\ArrayOfActivityRemark
     */
    public function addToActivityRemark(\StructType\ActivityRemark $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ActivityRemark) {
            throw new \InvalidArgumentException(sprintf('The ActivityRemark property can only contain items of type \StructType\ActivityRemark, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ActivityRemark[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ActivityRemark|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ActivityRemark|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ActivityRemark|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ActivityRemark|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ActivityRemark|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ActivityRemark
     */
    public function getAttributeName()
    {
        return 'ActivityRemark';
    }
}
