<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfActivityInfo_V5 ArrayType
 * @subpackage Arrays
 */
class ArrayOfActivityInfo_V5 extends AbstractStructArrayBase
{
    /**
     * The ActivityInfo_V5
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ActivityInfo_V5[]
     */
    public $ActivityInfo_V5;
    /**
     * Constructor method for ArrayOfActivityInfo_V5
     * @uses ArrayOfActivityInfo_V5::setActivityInfo_V5()
     * @param \StructType\ActivityInfo_V5[] $activityInfo_V5
     */
    public function __construct(array $activityInfo_V5 = array())
    {
        $this
            ->setActivityInfo_V5($activityInfo_V5);
    }
    /**
     * Get ActivityInfo_V5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ActivityInfo_V5[]|null
     */
    public function getActivityInfo_V5()
    {
        return isset($this->ActivityInfo_V5) ? $this->ActivityInfo_V5 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setActivityInfo_V5 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActivityInfo_V5 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActivityInfo_V5ForArrayConstraintsFromSetActivityInfo_V5(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfActivityInfo_V5ActivityInfo_V5Item) {
            // validation for constraint: itemType
            if (!$arrayOfActivityInfo_V5ActivityInfo_V5Item instanceof \StructType\ActivityInfo_V5) {
                $invalidValues[] = is_object($arrayOfActivityInfo_V5ActivityInfo_V5Item) ? get_class($arrayOfActivityInfo_V5ActivityInfo_V5Item) : sprintf('%s(%s)', gettype($arrayOfActivityInfo_V5ActivityInfo_V5Item), var_export($arrayOfActivityInfo_V5ActivityInfo_V5Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ActivityInfo_V5 property can only contain items of type \StructType\ActivityInfo_V5, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ActivityInfo_V5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityInfo_V5[] $activityInfo_V5
     * @return \ArrayType\ArrayOfActivityInfo_V5
     */
    public function setActivityInfo_V5(array $activityInfo_V5 = array())
    {
        // validation for constraint: array
        if ('' !== ($activityInfo_V5ArrayErrorMessage = self::validateActivityInfo_V5ForArrayConstraintsFromSetActivityInfo_V5($activityInfo_V5))) {
            throw new \InvalidArgumentException($activityInfo_V5ArrayErrorMessage, __LINE__);
        }
        if (is_null($activityInfo_V5) || (is_array($activityInfo_V5) && empty($activityInfo_V5))) {
            unset($this->ActivityInfo_V5);
        } else {
            $this->ActivityInfo_V5 = $activityInfo_V5;
        }
        return $this;
    }
    /**
     * Add item to ActivityInfo_V5 value
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityInfo_V5 $item
     * @return \ArrayType\ArrayOfActivityInfo_V5
     */
    public function addToActivityInfo_V5(\StructType\ActivityInfo_V5 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ActivityInfo_V5) {
            throw new \InvalidArgumentException(sprintf('The ActivityInfo_V5 property can only contain items of type \StructType\ActivityInfo_V5, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ActivityInfo_V5[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ActivityInfo_V5|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ActivityInfo_V5|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ActivityInfo_V5|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ActivityInfo_V5|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ActivityInfo_V5|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ActivityInfo_V5
     */
    public function getAttributeName()
    {
        return 'ActivityInfo_V5';
    }
}
