<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViaRouteResult StructType
 * @subpackage Structs
 */
class ViaRouteResult extends ViaRoute
{
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Active;
    /**
     * The Created
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Created;
    /**
     * The Distance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Distance;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Duration;
    /**
     * The Distance_Ferry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Distance_Ferry;
    /**
     * The Duration_Ferry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Duration_Ferry;
    /**
     * The Transfers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfViaRouteTransferResult
     */
    public $Transfers;
    /**
     * The Dispatcher
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Dispatcher;
    /**
     * The ViaPoints
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfViaPointResult
     */
    public $ViaPoints;
    /**
     * The Places
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPlaceIdentifier
     */
    public $Places;
    /**
     * Constructor method for ViaRouteResult
     * @uses ViaRouteResult::setActive()
     * @uses ViaRouteResult::setCreated()
     * @uses ViaRouteResult::setDistance()
     * @uses ViaRouteResult::setDuration()
     * @uses ViaRouteResult::setDistance_Ferry()
     * @uses ViaRouteResult::setDuration_Ferry()
     * @uses ViaRouteResult::setTransfers()
     * @uses ViaRouteResult::setDispatcher()
     * @uses ViaRouteResult::setViaPoints()
     * @uses ViaRouteResult::setPlaces()
     * @param bool $active
     * @param string $created
     * @param int $distance
     * @param int $duration
     * @param int $distance_Ferry
     * @param int $duration_Ferry
     * @param \ArrayType\ArrayOfViaRouteTransferResult $transfers
     * @param \StructType\IdentifierPerson $dispatcher
     * @param \ArrayType\ArrayOfViaPointResult $viaPoints
     * @param \ArrayType\ArrayOfPlaceIdentifier $places
     */
    public function __construct($active = null, $created = null, $distance = null, $duration = null, $distance_Ferry = null, $duration_Ferry = null, \ArrayType\ArrayOfViaRouteTransferResult $transfers = null, \StructType\IdentifierPerson $dispatcher = null, \ArrayType\ArrayOfViaPointResult $viaPoints = null, \ArrayType\ArrayOfPlaceIdentifier $places = null)
    {
        $this
            ->setActive($active)
            ->setCreated($created)
            ->setDistance($distance)
            ->setDuration($duration)
            ->setDistance_Ferry($distance_Ferry)
            ->setDuration_Ferry($duration_Ferry)
            ->setTransfers($transfers)
            ->setDispatcher($dispatcher)
            ->setViaPoints($viaPoints)
            ->setPlaces($places);
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\ViaRouteResult
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Created value
     * @return string
     */
    public function getCreated()
    {
        return $this->Created;
    }
    /**
     * Set Created value
     * @param string $created
     * @return \StructType\ViaRouteResult
     */
    public function setCreated($created = null)
    {
        // validation for constraint: string
        if (!is_null($created) && !is_string($created)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($created, true), gettype($created)), __LINE__);
        }
        $this->Created = $created;
        return $this;
    }
    /**
     * Get Distance value
     * @return int
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param int $distance
     * @return \StructType\ViaRouteResult
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: int
        if (!is_null($distance) && !(is_int($distance) || ctype_digit($distance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($distance, true), gettype($distance)), __LINE__);
        }
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get Duration value
     * @return int
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param int $duration
     * @return \StructType\ViaRouteResult
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !(is_int($duration) || ctype_digit($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get Distance_Ferry value
     * @return int
     */
    public function getDistance_Ferry()
    {
        return $this->Distance_Ferry;
    }
    /**
     * Set Distance_Ferry value
     * @param int $distance_Ferry
     * @return \StructType\ViaRouteResult
     */
    public function setDistance_Ferry($distance_Ferry = null)
    {
        // validation for constraint: int
        if (!is_null($distance_Ferry) && !(is_int($distance_Ferry) || ctype_digit($distance_Ferry))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($distance_Ferry, true), gettype($distance_Ferry)), __LINE__);
        }
        $this->Distance_Ferry = $distance_Ferry;
        return $this;
    }
    /**
     * Get Duration_Ferry value
     * @return int
     */
    public function getDuration_Ferry()
    {
        return $this->Duration_Ferry;
    }
    /**
     * Set Duration_Ferry value
     * @param int $duration_Ferry
     * @return \StructType\ViaRouteResult
     */
    public function setDuration_Ferry($duration_Ferry = null)
    {
        // validation for constraint: int
        if (!is_null($duration_Ferry) && !(is_int($duration_Ferry) || ctype_digit($duration_Ferry))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duration_Ferry, true), gettype($duration_Ferry)), __LINE__);
        }
        $this->Duration_Ferry = $duration_Ferry;
        return $this;
    }
    /**
     * Get Transfers value
     * @return \ArrayType\ArrayOfViaRouteTransferResult|null
     */
    public function getTransfers()
    {
        return $this->Transfers;
    }
    /**
     * Set Transfers value
     * @param \ArrayType\ArrayOfViaRouteTransferResult $transfers
     * @return \StructType\ViaRouteResult
     */
    public function setTransfers(\ArrayType\ArrayOfViaRouteTransferResult $transfers = null)
    {
        $this->Transfers = $transfers;
        return $this;
    }
    /**
     * Get Dispatcher value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDispatcher()
    {
        return $this->Dispatcher;
    }
    /**
     * Set Dispatcher value
     * @param \StructType\IdentifierPerson $dispatcher
     * @return \StructType\ViaRouteResult
     */
    public function setDispatcher(\StructType\IdentifierPerson $dispatcher = null)
    {
        $this->Dispatcher = $dispatcher;
        return $this;
    }
    /**
     * Get ViaPoints value
     * @return \ArrayType\ArrayOfViaPointResult|null
     */
    public function getViaPoints()
    {
        return $this->ViaPoints;
    }
    /**
     * Set ViaPoints value
     * @param \ArrayType\ArrayOfViaPointResult $viaPoints
     * @return \StructType\ViaRouteResult
     */
    public function setViaPoints(\ArrayType\ArrayOfViaPointResult $viaPoints = null)
    {
        $this->ViaPoints = $viaPoints;
        return $this;
    }
    /**
     * Get Places value
     * @return \ArrayType\ArrayOfPlaceIdentifier|null
     */
    public function getPlaces()
    {
        return $this->Places;
    }
    /**
     * Set Places value
     * @param \ArrayType\ArrayOfPlaceIdentifier $places
     * @return \StructType\ViaRouteResult
     */
    public function setPlaces(\ArrayType\ArrayOfPlaceIdentifier $places = null)
    {
        $this->Places = $places;
        return $this;
    }
}
