<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleUpdate StructType
 * @subpackage Structs
 */
class VehicleUpdate extends Vehicle
{
    /**
     * The BelgianManureBankCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BelgianManureBankCode;
    /**
     * The Purchase
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Purchase;
    /**
     * The Rented
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Rented;
    /**
     * The RentStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $RentStatus;
    /**
     * The TypeOfObc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TypeOfObc;
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Category;
    /**
     * The InstructionSetNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InstructionSetNumber;
    /**
     * The Site
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierSite
     */
    public $Site;
    /**
     * The VehicleToUpdate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicle
     */
    public $VehicleToUpdate;
    /**
     * The VehicleProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleProfile
     */
    public $VehicleProfile;
    /**
     * The ModemChannelId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ModemChannelId;
    /**
     * The AutoFilter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AutoFilter;
    /**
     * The GsmNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GsmNumber;
    /**
     * The HomebaseNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HomebaseNumber;
    /**
     * The CompanyCard
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyCard;
    /**
     * The DeviceSerial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeviceSerial;
    /**
     * Constructor method for VehicleUpdate
     * @uses VehicleUpdate::setBelgianManureBankCode()
     * @uses VehicleUpdate::setPurchase()
     * @uses VehicleUpdate::setRented()
     * @uses VehicleUpdate::setRentStatus()
     * @uses VehicleUpdate::setTypeOfObc()
     * @uses VehicleUpdate::setCategory()
     * @uses VehicleUpdate::setInstructionSetNumber()
     * @uses VehicleUpdate::setSite()
     * @uses VehicleUpdate::setVehicleToUpdate()
     * @uses VehicleUpdate::setVehicleProfile()
     * @uses VehicleUpdate::setModemChannelId()
     * @uses VehicleUpdate::setAutoFilter()
     * @uses VehicleUpdate::setGsmNumber()
     * @uses VehicleUpdate::setHomebaseNumber()
     * @uses VehicleUpdate::setCompanyCard()
     * @uses VehicleUpdate::setDeviceSerial()
     * @param int $belgianManureBankCode
     * @param string $purchase
     * @param bool $rented
     * @param bool $rentStatus
     * @param string $typeOfObc
     * @param string $category
     * @param int $instructionSetNumber
     * @param \StructType\IdentifierSite $site
     * @param \StructType\IdentifierVehicle $vehicleToUpdate
     * @param \StructType\VehicleProfile $vehicleProfile
     * @param string $modemChannelId
     * @param string $autoFilter
     * @param string $gsmNumber
     * @param string $homebaseNumber
     * @param string $companyCard
     * @param string $deviceSerial
     */
    public function __construct($belgianManureBankCode = null, $purchase = null, $rented = null, $rentStatus = null, $typeOfObc = null, $category = null, $instructionSetNumber = null, \StructType\IdentifierSite $site = null, \StructType\IdentifierVehicle $vehicleToUpdate = null, \StructType\VehicleProfile $vehicleProfile = null, $modemChannelId = null, $autoFilter = null, $gsmNumber = null, $homebaseNumber = null, $companyCard = null, $deviceSerial = null)
    {
        $this
            ->setBelgianManureBankCode($belgianManureBankCode)
            ->setPurchase($purchase)
            ->setRented($rented)
            ->setRentStatus($rentStatus)
            ->setTypeOfObc($typeOfObc)
            ->setCategory($category)
            ->setInstructionSetNumber($instructionSetNumber)
            ->setSite($site)
            ->setVehicleToUpdate($vehicleToUpdate)
            ->setVehicleProfile($vehicleProfile)
            ->setModemChannelId($modemChannelId)
            ->setAutoFilter($autoFilter)
            ->setGsmNumber($gsmNumber)
            ->setHomebaseNumber($homebaseNumber)
            ->setCompanyCard($companyCard)
            ->setDeviceSerial($deviceSerial);
    }
    /**
     * Get BelgianManureBankCode value
     * @return int
     */
    public function getBelgianManureBankCode()
    {
        return $this->BelgianManureBankCode;
    }
    /**
     * Set BelgianManureBankCode value
     * @param int $belgianManureBankCode
     * @return \StructType\VehicleUpdate
     */
    public function setBelgianManureBankCode($belgianManureBankCode = null)
    {
        // validation for constraint: int
        if (!is_null($belgianManureBankCode) && !(is_int($belgianManureBankCode) || ctype_digit($belgianManureBankCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($belgianManureBankCode, true), gettype($belgianManureBankCode)), __LINE__);
        }
        $this->BelgianManureBankCode = $belgianManureBankCode;
        return $this;
    }
    /**
     * Get Purchase value
     * @return string
     */
    public function getPurchase()
    {
        return $this->Purchase;
    }
    /**
     * Set Purchase value
     * @param string $purchase
     * @return \StructType\VehicleUpdate
     */
    public function setPurchase($purchase = null)
    {
        // validation for constraint: string
        if (!is_null($purchase) && !is_string($purchase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchase, true), gettype($purchase)), __LINE__);
        }
        $this->Purchase = $purchase;
        return $this;
    }
    /**
     * Get Rented value
     * @return bool
     */
    public function getRented()
    {
        return $this->Rented;
    }
    /**
     * Set Rented value
     * @param bool $rented
     * @return \StructType\VehicleUpdate
     */
    public function setRented($rented = null)
    {
        // validation for constraint: boolean
        if (!is_null($rented) && !is_bool($rented)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rented, true), gettype($rented)), __LINE__);
        }
        $this->Rented = $rented;
        return $this;
    }
    /**
     * Get RentStatus value
     * @return bool
     */
    public function getRentStatus()
    {
        return $this->RentStatus;
    }
    /**
     * Set RentStatus value
     * @param bool $rentStatus
     * @return \StructType\VehicleUpdate
     */
    public function setRentStatus($rentStatus = null)
    {
        // validation for constraint: boolean
        if (!is_null($rentStatus) && !is_bool($rentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rentStatus, true), gettype($rentStatus)), __LINE__);
        }
        $this->RentStatus = $rentStatus;
        return $this;
    }
    /**
     * Get TypeOfObc value
     * @return string
     */
    public function getTypeOfObc()
    {
        return $this->TypeOfObc;
    }
    /**
     * Set TypeOfObc value
     * @uses \EnumType\ObcType::valueIsValid()
     * @uses \EnumType\ObcType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeOfObc
     * @return \StructType\VehicleUpdate
     */
    public function setTypeOfObc($typeOfObc = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ObcType::valueIsValid($typeOfObc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ObcType', is_array($typeOfObc) ? implode(', ', $typeOfObc) : var_export($typeOfObc, true), implode(', ', \EnumType\ObcType::getValidValues())), __LINE__);
        }
        $this->TypeOfObc = $typeOfObc;
        return $this;
    }
    /**
     * Get Category value
     * @return string
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @uses \EnumType\VehicleCategory::valueIsValid()
     * @uses \EnumType\VehicleCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $category
     * @return \StructType\VehicleUpdate
     */
    public function setCategory($category = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VehicleCategory::valueIsValid($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VehicleCategory', is_array($category) ? implode(', ', $category) : var_export($category, true), implode(', ', \EnumType\VehicleCategory::getValidValues())), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get InstructionSetNumber value
     * @return int
     */
    public function getInstructionSetNumber()
    {
        return $this->InstructionSetNumber;
    }
    /**
     * Set InstructionSetNumber value
     * @param int $instructionSetNumber
     * @return \StructType\VehicleUpdate
     */
    public function setInstructionSetNumber($instructionSetNumber = null)
    {
        // validation for constraint: int
        if (!is_null($instructionSetNumber) && !(is_int($instructionSetNumber) || ctype_digit($instructionSetNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($instructionSetNumber, true), gettype($instructionSetNumber)), __LINE__);
        }
        $this->InstructionSetNumber = $instructionSetNumber;
        return $this;
    }
    /**
     * Get Site value
     * @return \StructType\IdentifierSite|null
     */
    public function getSite()
    {
        return $this->Site;
    }
    /**
     * Set Site value
     * @param \StructType\IdentifierSite $site
     * @return \StructType\VehicleUpdate
     */
    public function setSite(\StructType\IdentifierSite $site = null)
    {
        $this->Site = $site;
        return $this;
    }
    /**
     * Get VehicleToUpdate value
     * @return \StructType\IdentifierVehicle|null
     */
    public function getVehicleToUpdate()
    {
        return $this->VehicleToUpdate;
    }
    /**
     * Set VehicleToUpdate value
     * @param \StructType\IdentifierVehicle $vehicleToUpdate
     * @return \StructType\VehicleUpdate
     */
    public function setVehicleToUpdate(\StructType\IdentifierVehicle $vehicleToUpdate = null)
    {
        $this->VehicleToUpdate = $vehicleToUpdate;
        return $this;
    }
    /**
     * Get VehicleProfile value
     * @return \StructType\VehicleProfile|null
     */
    public function getVehicleProfile()
    {
        return $this->VehicleProfile;
    }
    /**
     * Set VehicleProfile value
     * @param \StructType\VehicleProfile $vehicleProfile
     * @return \StructType\VehicleUpdate
     */
    public function setVehicleProfile(\StructType\VehicleProfile $vehicleProfile = null)
    {
        $this->VehicleProfile = $vehicleProfile;
        return $this;
    }
    /**
     * Get ModemChannelId value
     * @return string|null
     */
    public function getModemChannelId()
    {
        return $this->ModemChannelId;
    }
    /**
     * Set ModemChannelId value
     * @param string $modemChannelId
     * @return \StructType\VehicleUpdate
     */
    public function setModemChannelId($modemChannelId = null)
    {
        // validation for constraint: string
        if (!is_null($modemChannelId) && !is_string($modemChannelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modemChannelId, true), gettype($modemChannelId)), __LINE__);
        }
        $this->ModemChannelId = $modemChannelId;
        return $this;
    }
    /**
     * Get AutoFilter value
     * @return string|null
     */
    public function getAutoFilter()
    {
        return $this->AutoFilter;
    }
    /**
     * Set AutoFilter value
     * @param string $autoFilter
     * @return \StructType\VehicleUpdate
     */
    public function setAutoFilter($autoFilter = null)
    {
        // validation for constraint: string
        if (!is_null($autoFilter) && !is_string($autoFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($autoFilter, true), gettype($autoFilter)), __LINE__);
        }
        $this->AutoFilter = $autoFilter;
        return $this;
    }
    /**
     * Get GsmNumber value
     * @return string|null
     */
    public function getGsmNumber()
    {
        return $this->GsmNumber;
    }
    /**
     * Set GsmNumber value
     * @param string $gsmNumber
     * @return \StructType\VehicleUpdate
     */
    public function setGsmNumber($gsmNumber = null)
    {
        // validation for constraint: string
        if (!is_null($gsmNumber) && !is_string($gsmNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gsmNumber, true), gettype($gsmNumber)), __LINE__);
        }
        $this->GsmNumber = $gsmNumber;
        return $this;
    }
    /**
     * Get HomebaseNumber value
     * @return string|null
     */
    public function getHomebaseNumber()
    {
        return $this->HomebaseNumber;
    }
    /**
     * Set HomebaseNumber value
     * @param string $homebaseNumber
     * @return \StructType\VehicleUpdate
     */
    public function setHomebaseNumber($homebaseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($homebaseNumber) && !is_string($homebaseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homebaseNumber, true), gettype($homebaseNumber)), __LINE__);
        }
        $this->HomebaseNumber = $homebaseNumber;
        return $this;
    }
    /**
     * Get CompanyCard value
     * @return string|null
     */
    public function getCompanyCard()
    {
        return $this->CompanyCard;
    }
    /**
     * Set CompanyCard value
     * @param string $companyCard
     * @return \StructType\VehicleUpdate
     */
    public function setCompanyCard($companyCard = null)
    {
        // validation for constraint: string
        if (!is_null($companyCard) && !is_string($companyCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyCard, true), gettype($companyCard)), __LINE__);
        }
        $this->CompanyCard = $companyCard;
        return $this;
    }
    /**
     * Get DeviceSerial value
     * @return string|null
     */
    public function getDeviceSerial()
    {
        return $this->DeviceSerial;
    }
    /**
     * Set DeviceSerial value
     * @param string $deviceSerial
     * @return \StructType\VehicleUpdate
     */
    public function setDeviceSerial($deviceSerial = null)
    {
        // validation for constraint: string
        if (!is_null($deviceSerial) && !is_string($deviceSerial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceSerial, true), gettype($deviceSerial)), __LINE__);
        }
        $this->DeviceSerial = $deviceSerial;
        return $this;
    }
}
