<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleProfile StructType
 * @subpackage Structs
 */
class VehicleProfile extends AbstractStructBase
{
    /**
     * The ProfileId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ProfileId;
    /**
     * The ProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProfileName;
    /**
     * Constructor method for VehicleProfile
     * @uses VehicleProfile::setProfileId()
     * @uses VehicleProfile::setProfileName()
     * @param int $profileId
     * @param string $profileName
     */
    public function __construct($profileId = null, $profileName = null)
    {
        $this
            ->setProfileId($profileId)
            ->setProfileName($profileName);
    }
    /**
     * Get ProfileId value
     * @return int
     */
    public function getProfileId()
    {
        return $this->ProfileId;
    }
    /**
     * Set ProfileId value
     * @param int $profileId
     * @return \StructType\VehicleProfile
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !(is_int($profileId) || ctype_digit($profileId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($profileId, true), gettype($profileId)), __LINE__);
        }
        $this->ProfileId = $profileId;
        return $this;
    }
    /**
     * Get ProfileName value
     * @return string|null
     */
    public function getProfileName()
    {
        return $this->ProfileName;
    }
    /**
     * Set ProfileName value
     * @param string $profileName
     * @return \StructType\VehicleProfile
     */
    public function setProfileName($profileName = null)
    {
        // validation for constraint: string
        if (!is_null($profileName) && !is_string($profileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profileName, true), gettype($profileName)), __LINE__);
        }
        $this->ProfileName = $profileName;
        return $this;
    }
}
