<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleOnDateSelection StructType
 * @subpackage Structs
 */
class VehicleOnDateSelection extends AbstractStructBase
{
    /**
     * The DateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateTime;
    /**
     * The Vehicles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierVehicle
     */
    public $Vehicles;
    /**
     * Constructor method for VehicleOnDateSelection
     * @uses VehicleOnDateSelection::setDateTime()
     * @uses VehicleOnDateSelection::setVehicles()
     * @param string $dateTime
     * @param \ArrayType\ArrayOfIdentifierVehicle $vehicles
     */
    public function __construct($dateTime = null, \ArrayType\ArrayOfIdentifierVehicle $vehicles = null)
    {
        $this
            ->setDateTime($dateTime)
            ->setVehicles($vehicles);
    }
    /**
     * Get DateTime value
     * @return string
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \StructType\VehicleOnDateSelection
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTime, true), gettype($dateTime)), __LINE__);
        }
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Get Vehicles value
     * @return \ArrayType\ArrayOfIdentifierVehicle|null
     */
    public function getVehicles()
    {
        return $this->Vehicles;
    }
    /**
     * Set Vehicles value
     * @param \ArrayType\ArrayOfIdentifierVehicle $vehicles
     * @return \StructType\VehicleOnDateSelection
     */
    public function setVehicles(\ArrayType\ArrayOfIdentifierVehicle $vehicles = null)
    {
        $this->Vehicles = $vehicles;
        return $this;
    }
}
