<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleCostInfo StructType
 * @subpackage Structs
 */
class VehicleCostInfo extends AbstractStructBase
{
    /**
     * The AvgConsumption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AvgConsumption;
    /**
     * The AvgCostPerDay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AvgCostPerDay;
    /**
     * The AvgCostPerHour
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AvgCostPerHour;
    /**
     * The AvgCostPerKilometer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AvgCostPerKilometer;
    /**
     * The KmsPerYear
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $KmsPerYear;
    /**
     * The BelgianManureBankCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BelgianManureBankCode;
    /**
     * The Purchase
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Purchase;
    /**
     * The Rented
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Rented;
    /**
     * The RentStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $RentStatus;
    /**
     * Constructor method for VehicleCostInfo
     * @uses VehicleCostInfo::setAvgConsumption()
     * @uses VehicleCostInfo::setAvgCostPerDay()
     * @uses VehicleCostInfo::setAvgCostPerHour()
     * @uses VehicleCostInfo::setAvgCostPerKilometer()
     * @uses VehicleCostInfo::setKmsPerYear()
     * @uses VehicleCostInfo::setBelgianManureBankCode()
     * @uses VehicleCostInfo::setPurchase()
     * @uses VehicleCostInfo::setRented()
     * @uses VehicleCostInfo::setRentStatus()
     * @param float $avgConsumption
     * @param float $avgCostPerDay
     * @param float $avgCostPerHour
     * @param float $avgCostPerKilometer
     * @param float $kmsPerYear
     * @param int $belgianManureBankCode
     * @param string $purchase
     * @param bool $rented
     * @param bool $rentStatus
     */
    public function __construct($avgConsumption = null, $avgCostPerDay = null, $avgCostPerHour = null, $avgCostPerKilometer = null, $kmsPerYear = null, $belgianManureBankCode = null, $purchase = null, $rented = null, $rentStatus = null)
    {
        $this
            ->setAvgConsumption($avgConsumption)
            ->setAvgCostPerDay($avgCostPerDay)
            ->setAvgCostPerHour($avgCostPerHour)
            ->setAvgCostPerKilometer($avgCostPerKilometer)
            ->setKmsPerYear($kmsPerYear)
            ->setBelgianManureBankCode($belgianManureBankCode)
            ->setPurchase($purchase)
            ->setRented($rented)
            ->setRentStatus($rentStatus);
    }
    /**
     * Get AvgConsumption value
     * @return float
     */
    public function getAvgConsumption()
    {
        return $this->AvgConsumption;
    }
    /**
     * Set AvgConsumption value
     * @param float $avgConsumption
     * @return \StructType\VehicleCostInfo
     */
    public function setAvgConsumption($avgConsumption = null)
    {
        // validation for constraint: float
        if (!is_null($avgConsumption) && !(is_float($avgConsumption) || is_numeric($avgConsumption))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($avgConsumption, true), gettype($avgConsumption)), __LINE__);
        }
        $this->AvgConsumption = $avgConsumption;
        return $this;
    }
    /**
     * Get AvgCostPerDay value
     * @return float
     */
    public function getAvgCostPerDay()
    {
        return $this->AvgCostPerDay;
    }
    /**
     * Set AvgCostPerDay value
     * @param float $avgCostPerDay
     * @return \StructType\VehicleCostInfo
     */
    public function setAvgCostPerDay($avgCostPerDay = null)
    {
        // validation for constraint: float
        if (!is_null($avgCostPerDay) && !(is_float($avgCostPerDay) || is_numeric($avgCostPerDay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($avgCostPerDay, true), gettype($avgCostPerDay)), __LINE__);
        }
        $this->AvgCostPerDay = $avgCostPerDay;
        return $this;
    }
    /**
     * Get AvgCostPerHour value
     * @return float
     */
    public function getAvgCostPerHour()
    {
        return $this->AvgCostPerHour;
    }
    /**
     * Set AvgCostPerHour value
     * @param float $avgCostPerHour
     * @return \StructType\VehicleCostInfo
     */
    public function setAvgCostPerHour($avgCostPerHour = null)
    {
        // validation for constraint: float
        if (!is_null($avgCostPerHour) && !(is_float($avgCostPerHour) || is_numeric($avgCostPerHour))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($avgCostPerHour, true), gettype($avgCostPerHour)), __LINE__);
        }
        $this->AvgCostPerHour = $avgCostPerHour;
        return $this;
    }
    /**
     * Get AvgCostPerKilometer value
     * @return float
     */
    public function getAvgCostPerKilometer()
    {
        return $this->AvgCostPerKilometer;
    }
    /**
     * Set AvgCostPerKilometer value
     * @param float $avgCostPerKilometer
     * @return \StructType\VehicleCostInfo
     */
    public function setAvgCostPerKilometer($avgCostPerKilometer = null)
    {
        // validation for constraint: float
        if (!is_null($avgCostPerKilometer) && !(is_float($avgCostPerKilometer) || is_numeric($avgCostPerKilometer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($avgCostPerKilometer, true), gettype($avgCostPerKilometer)), __LINE__);
        }
        $this->AvgCostPerKilometer = $avgCostPerKilometer;
        return $this;
    }
    /**
     * Get KmsPerYear value
     * @return float
     */
    public function getKmsPerYear()
    {
        return $this->KmsPerYear;
    }
    /**
     * Set KmsPerYear value
     * @param float $kmsPerYear
     * @return \StructType\VehicleCostInfo
     */
    public function setKmsPerYear($kmsPerYear = null)
    {
        // validation for constraint: float
        if (!is_null($kmsPerYear) && !(is_float($kmsPerYear) || is_numeric($kmsPerYear))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kmsPerYear, true), gettype($kmsPerYear)), __LINE__);
        }
        $this->KmsPerYear = $kmsPerYear;
        return $this;
    }
    /**
     * Get BelgianManureBankCode value
     * @return int
     */
    public function getBelgianManureBankCode()
    {
        return $this->BelgianManureBankCode;
    }
    /**
     * Set BelgianManureBankCode value
     * @param int $belgianManureBankCode
     * @return \StructType\VehicleCostInfo
     */
    public function setBelgianManureBankCode($belgianManureBankCode = null)
    {
        // validation for constraint: int
        if (!is_null($belgianManureBankCode) && !(is_int($belgianManureBankCode) || ctype_digit($belgianManureBankCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($belgianManureBankCode, true), gettype($belgianManureBankCode)), __LINE__);
        }
        $this->BelgianManureBankCode = $belgianManureBankCode;
        return $this;
    }
    /**
     * Get Purchase value
     * @return string
     */
    public function getPurchase()
    {
        return $this->Purchase;
    }
    /**
     * Set Purchase value
     * @param string $purchase
     * @return \StructType\VehicleCostInfo
     */
    public function setPurchase($purchase = null)
    {
        // validation for constraint: string
        if (!is_null($purchase) && !is_string($purchase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchase, true), gettype($purchase)), __LINE__);
        }
        $this->Purchase = $purchase;
        return $this;
    }
    /**
     * Get Rented value
     * @return bool
     */
    public function getRented()
    {
        return $this->Rented;
    }
    /**
     * Set Rented value
     * @param bool $rented
     * @return \StructType\VehicleCostInfo
     */
    public function setRented($rented = null)
    {
        // validation for constraint: boolean
        if (!is_null($rented) && !is_bool($rented)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rented, true), gettype($rented)), __LINE__);
        }
        $this->Rented = $rented;
        return $this;
    }
    /**
     * Get RentStatus value
     * @return bool
     */
    public function getRentStatus()
    {
        return $this->RentStatus;
    }
    /**
     * Set RentStatus value
     * @param bool $rentStatus
     * @return \StructType\VehicleCostInfo
     */
    public function setRentStatus($rentStatus = null)
    {
        // validation for constraint: boolean
        if (!is_null($rentStatus) && !is_bool($rentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rentStatus, true), gettype($rentStatus)), __LINE__);
        }
        $this->RentStatus = $rentStatus;
        return $this;
    }
}
