<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TxConnect StructType
 * @subpackage Structs
 */
class TxConnect extends AssignDriverToGroupStrategySelection
{
    /**
     * The GroupCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupCode;
    /**
     * The SubGroupCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubGroupCode;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Identifier
     */
    public $Driver;
    /**
     * Constructor method for TxConnect
     * @uses TxConnect::setGroupCode()
     * @uses TxConnect::setSubGroupCode()
     * @uses TxConnect::setDriver()
     * @param string $groupCode
     * @param string $subGroupCode
     * @param \StructType\Identifier $driver
     */
    public function __construct($groupCode = null, $subGroupCode = null, \StructType\Identifier $driver = null)
    {
        $this
            ->setGroupCode($groupCode)
            ->setSubGroupCode($subGroupCode)
            ->setDriver($driver);
    }
    /**
     * Get GroupCode value
     * @return string|null
     */
    public function getGroupCode()
    {
        return $this->GroupCode;
    }
    /**
     * Set GroupCode value
     * @param string $groupCode
     * @return \StructType\TxConnect
     */
    public function setGroupCode($groupCode = null)
    {
        // validation for constraint: string
        if (!is_null($groupCode) && !is_string($groupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupCode, true), gettype($groupCode)), __LINE__);
        }
        $this->GroupCode = $groupCode;
        return $this;
    }
    /**
     * Get SubGroupCode value
     * @return string|null
     */
    public function getSubGroupCode()
    {
        return $this->SubGroupCode;
    }
    /**
     * Set SubGroupCode value
     * @param string $subGroupCode
     * @return \StructType\TxConnect
     */
    public function setSubGroupCode($subGroupCode = null)
    {
        // validation for constraint: string
        if (!is_null($subGroupCode) && !is_string($subGroupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subGroupCode, true), gettype($subGroupCode)), __LINE__);
        }
        $this->SubGroupCode = $subGroupCode;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\Identifier|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\Identifier $driver
     * @return \StructType\TxConnect
     */
    public function setDriver(\StructType\Identifier $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
}
