<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TripResultInsert StructType
 * @subpackage Structs
 */
class TripResultInsert extends AbstractStructBase
{
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Action;
    /**
     * The TripId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TripId;
    /**
     * The Places
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPlaceResultInsert
     */
    public $Places;
    /**
     * Constructor method for TripResultInsert
     * @uses TripResultInsert::setAction()
     * @uses TripResultInsert::setTripId()
     * @uses TripResultInsert::setPlaces()
     * @param string $action
     * @param string $tripId
     * @param \ArrayType\ArrayOfPlaceResultInsert $places
     */
    public function __construct($action = null, $tripId = null, \ArrayType\ArrayOfPlaceResultInsert $places = null)
    {
        $this
            ->setAction($action)
            ->setTripId($tripId)
            ->setPlaces($places);
    }
    /**
     * Get Action value
     * @return string
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \EnumType\EnumPlanningActionType::valueIsValid()
     * @uses \EnumType\EnumPlanningActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \StructType\TripResultInsert
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumPlanningActionType::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumPlanningActionType', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \EnumType\EnumPlanningActionType::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get TripId value
     * @return string|null
     */
    public function getTripId()
    {
        return $this->TripId;
    }
    /**
     * Set TripId value
     * @param string $tripId
     * @return \StructType\TripResultInsert
     */
    public function setTripId($tripId = null)
    {
        // validation for constraint: string
        if (!is_null($tripId) && !is_string($tripId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tripId, true), gettype($tripId)), __LINE__);
        }
        $this->TripId = $tripId;
        return $this;
    }
    /**
     * Get Places value
     * @return \ArrayType\ArrayOfPlaceResultInsert|null
     */
    public function getPlaces()
    {
        return $this->Places;
    }
    /**
     * Set Places value
     * @param \ArrayType\ArrayOfPlaceResultInsert $places
     * @return \StructType\TripResultInsert
     */
    public function setPlaces(\ArrayType\ArrayOfPlaceResultInsert $places = null)
    {
        $this->Places = $places;
        return $this;
    }
}
