<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrailerSubGroupItem StructType
 * @subpackage Structs
 */
class TrailerSubGroupItem extends AbstractStructBase
{
    /**
     * The SubGroupCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubGroupCode;
    /**
     * The SubGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubGroupName;
    /**
     * The TrailerList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTrackedVehicle
     */
    public $TrailerList;
    /**
     * Constructor method for TrailerSubGroupItem
     * @uses TrailerSubGroupItem::setSubGroupCode()
     * @uses TrailerSubGroupItem::setSubGroupName()
     * @uses TrailerSubGroupItem::setTrailerList()
     * @param string $subGroupCode
     * @param string $subGroupName
     * @param \ArrayType\ArrayOfTrackedVehicle $trailerList
     */
    public function __construct($subGroupCode = null, $subGroupName = null, \ArrayType\ArrayOfTrackedVehicle $trailerList = null)
    {
        $this
            ->setSubGroupCode($subGroupCode)
            ->setSubGroupName($subGroupName)
            ->setTrailerList($trailerList);
    }
    /**
     * Get SubGroupCode value
     * @return string|null
     */
    public function getSubGroupCode()
    {
        return $this->SubGroupCode;
    }
    /**
     * Set SubGroupCode value
     * @param string $subGroupCode
     * @return \StructType\TrailerSubGroupItem
     */
    public function setSubGroupCode($subGroupCode = null)
    {
        // validation for constraint: string
        if (!is_null($subGroupCode) && !is_string($subGroupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subGroupCode, true), gettype($subGroupCode)), __LINE__);
        }
        $this->SubGroupCode = $subGroupCode;
        return $this;
    }
    /**
     * Get SubGroupName value
     * @return string|null
     */
    public function getSubGroupName()
    {
        return $this->SubGroupName;
    }
    /**
     * Set SubGroupName value
     * @param string $subGroupName
     * @return \StructType\TrailerSubGroupItem
     */
    public function setSubGroupName($subGroupName = null)
    {
        // validation for constraint: string
        if (!is_null($subGroupName) && !is_string($subGroupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subGroupName, true), gettype($subGroupName)), __LINE__);
        }
        $this->SubGroupName = $subGroupName;
        return $this;
    }
    /**
     * Get TrailerList value
     * @return \ArrayType\ArrayOfTrackedVehicle|null
     */
    public function getTrailerList()
    {
        return $this->TrailerList;
    }
    /**
     * Set TrailerList value
     * @param \ArrayType\ArrayOfTrackedVehicle $trailerList
     * @return \StructType\TrailerSubGroupItem
     */
    public function setTrailerList(\ArrayType\ArrayOfTrackedVehicle $trailerList = null)
    {
        $this->TrailerList = $trailerList;
        return $this;
    }
}
