<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrailerStrategy StructType
 * @subpackage Structs
 */
class TrailerStrategy extends IdentifierVehicleStrategy
{
    /**
     * The IdentifierVehicleType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IdentifierVehicleType;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * Constructor method for TrailerStrategy
     * @uses TrailerStrategy::setIdentifierVehicleType()
     * @uses TrailerStrategy::setId()
     * @param string $identifierVehicleType
     * @param string $id
     */
    public function __construct($identifierVehicleType = null, $id = null)
    {
        $this
            ->setIdentifierVehicleType($identifierVehicleType)
            ->setId($id);
    }
    /**
     * Get IdentifierVehicleType value
     * @return string
     */
    public function getIdentifierVehicleType()
    {
        return $this->IdentifierVehicleType;
    }
    /**
     * Set IdentifierVehicleType value
     * @uses \EnumType\EnumIdentifierVehicleType::valueIsValid()
     * @uses \EnumType\EnumIdentifierVehicleType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $identifierVehicleType
     * @return \StructType\TrailerStrategy
     */
    public function setIdentifierVehicleType($identifierVehicleType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumIdentifierVehicleType::valueIsValid($identifierVehicleType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumIdentifierVehicleType', is_array($identifierVehicleType) ? implode(', ', $identifierVehicleType) : var_export($identifierVehicleType, true), implode(', ', \EnumType\EnumIdentifierVehicleType::getValidValues())), __LINE__);
        }
        $this->IdentifierVehicleType = $identifierVehicleType;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\TrailerStrategy
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
}
