<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrailerItem StructType
 * @subpackage Structs
 */
class TrailerItem extends AbstractStructBase
{
    /**
     * The TransicsId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransicsId;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActive;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The LicensePlate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LicensePlate;
    /**
     * The Filter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Filter;
    /**
     * The FormattedName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FormattedName;
    /**
     * Constructor method for TrailerItem
     * @uses TrailerItem::setTransicsId()
     * @uses TrailerItem::setIsActive()
     * @uses TrailerItem::setId()
     * @uses TrailerItem::setCode()
     * @uses TrailerItem::setLicensePlate()
     * @uses TrailerItem::setFilter()
     * @uses TrailerItem::setFormattedName()
     * @param int $transicsId
     * @param bool $isActive
     * @param string $id
     * @param string $code
     * @param string $licensePlate
     * @param string $filter
     * @param string $formattedName
     */
    public function __construct($transicsId = null, $isActive = null, $id = null, $code = null, $licensePlate = null, $filter = null, $formattedName = null)
    {
        $this
            ->setTransicsId($transicsId)
            ->setIsActive($isActive)
            ->setId($id)
            ->setCode($code)
            ->setLicensePlate($licensePlate)
            ->setFilter($filter)
            ->setFormattedName($formattedName);
    }
    /**
     * Get TransicsId value
     * @return int
     */
    public function getTransicsId()
    {
        return $this->TransicsId;
    }
    /**
     * Set TransicsId value
     * @param int $transicsId
     * @return \StructType\TrailerItem
     */
    public function setTransicsId($transicsId = null)
    {
        // validation for constraint: int
        if (!is_null($transicsId) && !(is_int($transicsId) || ctype_digit($transicsId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transicsId, true), gettype($transicsId)), __LINE__);
        }
        $this->TransicsId = $transicsId;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \StructType\TrailerItem
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\TrailerItem
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\TrailerItem
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get LicensePlate value
     * @return string|null
     */
    public function getLicensePlate()
    {
        return $this->LicensePlate;
    }
    /**
     * Set LicensePlate value
     * @param string $licensePlate
     * @return \StructType\TrailerItem
     */
    public function setLicensePlate($licensePlate = null)
    {
        // validation for constraint: string
        if (!is_null($licensePlate) && !is_string($licensePlate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licensePlate, true), gettype($licensePlate)), __LINE__);
        }
        $this->LicensePlate = $licensePlate;
        return $this;
    }
    /**
     * Get Filter value
     * @return string|null
     */
    public function getFilter()
    {
        return $this->Filter;
    }
    /**
     * Set Filter value
     * @param string $filter
     * @return \StructType\TrailerItem
     */
    public function setFilter($filter = null)
    {
        // validation for constraint: string
        if (!is_null($filter) && !is_string($filter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filter, true), gettype($filter)), __LINE__);
        }
        $this->Filter = $filter;
        return $this;
    }
    /**
     * Get FormattedName value
     * @return string|null
     */
    public function getFormattedName()
    {
        return $this->FormattedName;
    }
    /**
     * Set FormattedName value
     * @param string $formattedName
     * @return \StructType\TrailerItem
     */
    public function setFormattedName($formattedName = null)
    {
        // validation for constraint: string
        if (!is_null($formattedName) && !is_string($formattedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formattedName, true), gettype($formattedName)), __LINE__);
        }
        $this->FormattedName = $formattedName;
        return $this;
    }
}
