<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackedVehicle StructType
 * @subpackage Structs
 */
class TrackedVehicle extends AbstractStructBase
{
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Active;
    /**
     * The TransicsID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransicsID;
    /**
     * The TrackingPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TrackingPeriod
     */
    public $TrackingPeriod;
    /**
     * The FormattedName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FormattedName;
    /**
     * The LicensePlate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LicensePlate;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Filter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Filter;
    /**
     * Constructor method for TrackedVehicle
     * @uses TrackedVehicle::setActive()
     * @uses TrackedVehicle::setTransicsID()
     * @uses TrackedVehicle::setTrackingPeriod()
     * @uses TrackedVehicle::setFormattedName()
     * @uses TrackedVehicle::setLicensePlate()
     * @uses TrackedVehicle::setID()
     * @uses TrackedVehicle::setCode()
     * @uses TrackedVehicle::setFilter()
     * @param bool $active
     * @param int $transicsID
     * @param \StructType\TrackingPeriod $trackingPeriod
     * @param string $formattedName
     * @param string $licensePlate
     * @param string $iD
     * @param string $code
     * @param string $filter
     */
    public function __construct($active = null, $transicsID = null, \StructType\TrackingPeriod $trackingPeriod = null, $formattedName = null, $licensePlate = null, $iD = null, $code = null, $filter = null)
    {
        $this
            ->setActive($active)
            ->setTransicsID($transicsID)
            ->setTrackingPeriod($trackingPeriod)
            ->setFormattedName($formattedName)
            ->setLicensePlate($licensePlate)
            ->setID($iD)
            ->setCode($code)
            ->setFilter($filter);
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\TrackedVehicle
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get TransicsID value
     * @return int
     */
    public function getTransicsID()
    {
        return $this->TransicsID;
    }
    /**
     * Set TransicsID value
     * @param int $transicsID
     * @return \StructType\TrackedVehicle
     */
    public function setTransicsID($transicsID = null)
    {
        // validation for constraint: int
        if (!is_null($transicsID) && !(is_int($transicsID) || ctype_digit($transicsID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transicsID, true), gettype($transicsID)), __LINE__);
        }
        $this->TransicsID = $transicsID;
        return $this;
    }
    /**
     * Get TrackingPeriod value
     * @return \StructType\TrackingPeriod|null
     */
    public function getTrackingPeriod()
    {
        return $this->TrackingPeriod;
    }
    /**
     * Set TrackingPeriod value
     * @param \StructType\TrackingPeriod $trackingPeriod
     * @return \StructType\TrackedVehicle
     */
    public function setTrackingPeriod(\StructType\TrackingPeriod $trackingPeriod = null)
    {
        $this->TrackingPeriod = $trackingPeriod;
        return $this;
    }
    /**
     * Get FormattedName value
     * @return string|null
     */
    public function getFormattedName()
    {
        return $this->FormattedName;
    }
    /**
     * Set FormattedName value
     * @param string $formattedName
     * @return \StructType\TrackedVehicle
     */
    public function setFormattedName($formattedName = null)
    {
        // validation for constraint: string
        if (!is_null($formattedName) && !is_string($formattedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formattedName, true), gettype($formattedName)), __LINE__);
        }
        $this->FormattedName = $formattedName;
        return $this;
    }
    /**
     * Get LicensePlate value
     * @return string|null
     */
    public function getLicensePlate()
    {
        return $this->LicensePlate;
    }
    /**
     * Set LicensePlate value
     * @param string $licensePlate
     * @return \StructType\TrackedVehicle
     */
    public function setLicensePlate($licensePlate = null)
    {
        // validation for constraint: string
        if (!is_null($licensePlate) && !is_string($licensePlate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licensePlate, true), gettype($licensePlate)), __LINE__);
        }
        $this->LicensePlate = $licensePlate;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\TrackedVehicle
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\TrackedVehicle
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Filter value
     * @return string|null
     */
    public function getFilter()
    {
        return $this->Filter;
    }
    /**
     * Set Filter value
     * @param string $filter
     * @return \StructType\TrackedVehicle
     */
    public function setFilter($filter = null)
    {
        // validation for constraint: string
        if (!is_null($filter) && !is_string($filter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filter, true), gettype($filter)), __LINE__);
        }
        $this->Filter = $filter;
        return $this;
    }
}
