<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TracerDistanceReportItem StructType
 * @subpackage Structs
 */
class TracerDistanceReportItem extends AbstractStructBase
{
    /**
     * The DateBegin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DateBegin;
    /**
     * The DateEnd
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DateEnd;
    /**
     * The KmMin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $KmMin;
    /**
     * The kmMax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $kmMax;
    /**
     * The Distance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Distance;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Date;
    /**
     * The ConfidenceIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ConfidenceIndicator;
    /**
     * The Trailer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Trailer;
    /**
     * The GpsPlace_Begin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GpsPlace_Begin;
    /**
     * The GpsPlace_End
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GpsPlace_End;
    /**
     * The Country_Code_Begin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country_Code_Begin;
    /**
     * The Country_Code_End
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country_Code_End;
    /**
     * Constructor method for TracerDistanceReportItem
     * @uses TracerDistanceReportItem::setDateBegin()
     * @uses TracerDistanceReportItem::setDateEnd()
     * @uses TracerDistanceReportItem::setKmMin()
     * @uses TracerDistanceReportItem::setKmMax()
     * @uses TracerDistanceReportItem::setDistance()
     * @uses TracerDistanceReportItem::setDate()
     * @uses TracerDistanceReportItem::setConfidenceIndicator()
     * @uses TracerDistanceReportItem::setTrailer()
     * @uses TracerDistanceReportItem::setGpsPlace_Begin()
     * @uses TracerDistanceReportItem::setGpsPlace_End()
     * @uses TracerDistanceReportItem::setCountry_Code_Begin()
     * @uses TracerDistanceReportItem::setCountry_Code_End()
     * @param string $dateBegin
     * @param string $dateEnd
     * @param int $kmMin
     * @param int $kmMax
     * @param int $distance
     * @param string $date
     * @param int $confidenceIndicator
     * @param \StructType\IdentifierVehicleResult $trailer
     * @param string $gpsPlace_Begin
     * @param string $gpsPlace_End
     * @param string $country_Code_Begin
     * @param string $country_Code_End
     */
    public function __construct($dateBegin = null, $dateEnd = null, $kmMin = null, $kmMax = null, $distance = null, $date = null, $confidenceIndicator = null, \StructType\IdentifierVehicleResult $trailer = null, $gpsPlace_Begin = null, $gpsPlace_End = null, $country_Code_Begin = null, $country_Code_End = null)
    {
        $this
            ->setDateBegin($dateBegin)
            ->setDateEnd($dateEnd)
            ->setKmMin($kmMin)
            ->setKmMax($kmMax)
            ->setDistance($distance)
            ->setDate($date)
            ->setConfidenceIndicator($confidenceIndicator)
            ->setTrailer($trailer)
            ->setGpsPlace_Begin($gpsPlace_Begin)
            ->setGpsPlace_End($gpsPlace_End)
            ->setCountry_Code_Begin($country_Code_Begin)
            ->setCountry_Code_End($country_Code_End);
    }
    /**
     * Get DateBegin value
     * @return string
     */
    public function getDateBegin()
    {
        return $this->DateBegin;
    }
    /**
     * Set DateBegin value
     * @param string $dateBegin
     * @return \StructType\TracerDistanceReportItem
     */
    public function setDateBegin($dateBegin = null)
    {
        // validation for constraint: string
        if (!is_null($dateBegin) && !is_string($dateBegin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateBegin, true), gettype($dateBegin)), __LINE__);
        }
        $this->DateBegin = $dateBegin;
        return $this;
    }
    /**
     * Get DateEnd value
     * @return string
     */
    public function getDateEnd()
    {
        return $this->DateEnd;
    }
    /**
     * Set DateEnd value
     * @param string $dateEnd
     * @return \StructType\TracerDistanceReportItem
     */
    public function setDateEnd($dateEnd = null)
    {
        // validation for constraint: string
        if (!is_null($dateEnd) && !is_string($dateEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateEnd, true), gettype($dateEnd)), __LINE__);
        }
        $this->DateEnd = $dateEnd;
        return $this;
    }
    /**
     * Get KmMin value
     * @return int
     */
    public function getKmMin()
    {
        return $this->KmMin;
    }
    /**
     * Set KmMin value
     * @param int $kmMin
     * @return \StructType\TracerDistanceReportItem
     */
    public function setKmMin($kmMin = null)
    {
        // validation for constraint: int
        if (!is_null($kmMin) && !(is_int($kmMin) || ctype_digit($kmMin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kmMin, true), gettype($kmMin)), __LINE__);
        }
        $this->KmMin = $kmMin;
        return $this;
    }
    /**
     * Get kmMax value
     * @return int
     */
    public function getKmMax()
    {
        return $this->kmMax;
    }
    /**
     * Set kmMax value
     * @param int $kmMax
     * @return \StructType\TracerDistanceReportItem
     */
    public function setKmMax($kmMax = null)
    {
        // validation for constraint: int
        if (!is_null($kmMax) && !(is_int($kmMax) || ctype_digit($kmMax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kmMax, true), gettype($kmMax)), __LINE__);
        }
        $this->kmMax = $kmMax;
        return $this;
    }
    /**
     * Get Distance value
     * @return int
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param int $distance
     * @return \StructType\TracerDistanceReportItem
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: int
        if (!is_null($distance) && !(is_int($distance) || ctype_digit($distance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($distance, true), gettype($distance)), __LINE__);
        }
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\TracerDistanceReportItem
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get ConfidenceIndicator value
     * @return int
     */
    public function getConfidenceIndicator()
    {
        return $this->ConfidenceIndicator;
    }
    /**
     * Set ConfidenceIndicator value
     * @param int $confidenceIndicator
     * @return \StructType\TracerDistanceReportItem
     */
    public function setConfidenceIndicator($confidenceIndicator = null)
    {
        // validation for constraint: int
        if (!is_null($confidenceIndicator) && !(is_int($confidenceIndicator) || ctype_digit($confidenceIndicator))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($confidenceIndicator, true), gettype($confidenceIndicator)), __LINE__);
        }
        $this->ConfidenceIndicator = $confidenceIndicator;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierVehicleResult $trailer
     * @return \StructType\TracerDistanceReportItem
     */
    public function setTrailer(\StructType\IdentifierVehicleResult $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get GpsPlace_Begin value
     * @return string|null
     */
    public function getGpsPlace_Begin()
    {
        return $this->GpsPlace_Begin;
    }
    /**
     * Set GpsPlace_Begin value
     * @param string $gpsPlace_Begin
     * @return \StructType\TracerDistanceReportItem
     */
    public function setGpsPlace_Begin($gpsPlace_Begin = null)
    {
        // validation for constraint: string
        if (!is_null($gpsPlace_Begin) && !is_string($gpsPlace_Begin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gpsPlace_Begin, true), gettype($gpsPlace_Begin)), __LINE__);
        }
        $this->GpsPlace_Begin = $gpsPlace_Begin;
        return $this;
    }
    /**
     * Get GpsPlace_End value
     * @return string|null
     */
    public function getGpsPlace_End()
    {
        return $this->GpsPlace_End;
    }
    /**
     * Set GpsPlace_End value
     * @param string $gpsPlace_End
     * @return \StructType\TracerDistanceReportItem
     */
    public function setGpsPlace_End($gpsPlace_End = null)
    {
        // validation for constraint: string
        if (!is_null($gpsPlace_End) && !is_string($gpsPlace_End)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gpsPlace_End, true), gettype($gpsPlace_End)), __LINE__);
        }
        $this->GpsPlace_End = $gpsPlace_End;
        return $this;
    }
    /**
     * Get Country_Code_Begin value
     * @return string|null
     */
    public function getCountry_Code_Begin()
    {
        return $this->Country_Code_Begin;
    }
    /**
     * Set Country_Code_Begin value
     * @param string $country_Code_Begin
     * @return \StructType\TracerDistanceReportItem
     */
    public function setCountry_Code_Begin($country_Code_Begin = null)
    {
        // validation for constraint: string
        if (!is_null($country_Code_Begin) && !is_string($country_Code_Begin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country_Code_Begin, true), gettype($country_Code_Begin)), __LINE__);
        }
        $this->Country_Code_Begin = $country_Code_Begin;
        return $this;
    }
    /**
     * Get Country_Code_End value
     * @return string|null
     */
    public function getCountry_Code_End()
    {
        return $this->Country_Code_End;
    }
    /**
     * Set Country_Code_End value
     * @param string $country_Code_End
     * @return \StructType\TracerDistanceReportItem
     */
    public function setCountry_Code_End($country_Code_End = null)
    {
        // validation for constraint: string
        if (!is_null($country_Code_End) && !is_string($country_Code_End)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country_Code_End, true), gettype($country_Code_End)), __LINE__);
        }
        $this->Country_Code_End = $country_Code_End;
        return $this;
    }
}
