<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TextMessageOutbox_V3 StructType
 * @subpackage Structs
 */
class TextMessageOutbox_V3 extends TextMessage
{
    /**
     * The TextMessageID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TextMessageID;
    /**
     * The DeliveredDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DeliveredDate;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The ModifiedDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ModifiedDate;
    /**
     * The ArrivalDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * The Read
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Read;
    /**
     * The ReadDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ReadDate;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The ForceOBCWakeUp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ForceOBCWakeUp;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Trailer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Trailer;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * The Dispatcher
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Dispatcher;
    /**
     * The InboxMessageRepliedFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TextMessageInbox_V3
     */
    public $InboxMessageRepliedFrom;
    /**
     * The RepliesOnOutboxMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTextMessageInbox_V3
     */
    public $RepliesOnOutboxMessage;
    /**
     * Constructor method for TextMessageOutbox_V3
     * @uses TextMessageOutbox_V3::setTextMessageID()
     * @uses TextMessageOutbox_V3::setDeliveredDate()
     * @uses TextMessageOutbox_V3::setCreationDate()
     * @uses TextMessageOutbox_V3::setModifiedDate()
     * @uses TextMessageOutbox_V3::setArrivalDateTime()
     * @uses TextMessageOutbox_V3::setRead()
     * @uses TextMessageOutbox_V3::setReadDate()
     * @uses TextMessageOutbox_V3::setStatus()
     * @uses TextMessageOutbox_V3::setForceOBCWakeUp()
     * @uses TextMessageOutbox_V3::setVehicle()
     * @uses TextMessageOutbox_V3::setTrailer()
     * @uses TextMessageOutbox_V3::setDriver()
     * @uses TextMessageOutbox_V3::setDispatcher()
     * @uses TextMessageOutbox_V3::setInboxMessageRepliedFrom()
     * @uses TextMessageOutbox_V3::setRepliesOnOutboxMessage()
     * @param int $textMessageID
     * @param string $deliveredDate
     * @param string $creationDate
     * @param string $modifiedDate
     * @param string $arrivalDateTime
     * @param bool $read
     * @param string $readDate
     * @param string $status
     * @param bool $forceOBCWakeUp
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \StructType\IdentifierVehicleResult $trailer
     * @param \StructType\IdentifierPerson $driver
     * @param \StructType\IdentifierPerson $dispatcher
     * @param \StructType\TextMessageInbox_V3 $inboxMessageRepliedFrom
     * @param \ArrayType\ArrayOfTextMessageInbox_V3 $repliesOnOutboxMessage
     */
    public function __construct($textMessageID = null, $deliveredDate = null, $creationDate = null, $modifiedDate = null, $arrivalDateTime = null, $read = null, $readDate = null, $status = null, $forceOBCWakeUp = null, \StructType\IdentifierVehicleResult $vehicle = null, \StructType\IdentifierVehicleResult $trailer = null, \StructType\IdentifierPerson $driver = null, \StructType\IdentifierPerson $dispatcher = null, \StructType\TextMessageInbox_V3 $inboxMessageRepliedFrom = null, \ArrayType\ArrayOfTextMessageInbox_V3 $repliesOnOutboxMessage = null)
    {
        $this
            ->setTextMessageID($textMessageID)
            ->setDeliveredDate($deliveredDate)
            ->setCreationDate($creationDate)
            ->setModifiedDate($modifiedDate)
            ->setArrivalDateTime($arrivalDateTime)
            ->setRead($read)
            ->setReadDate($readDate)
            ->setStatus($status)
            ->setForceOBCWakeUp($forceOBCWakeUp)
            ->setVehicle($vehicle)
            ->setTrailer($trailer)
            ->setDriver($driver)
            ->setDispatcher($dispatcher)
            ->setInboxMessageRepliedFrom($inboxMessageRepliedFrom)
            ->setRepliesOnOutboxMessage($repliesOnOutboxMessage);
    }
    /**
     * Get TextMessageID value
     * @return int
     */
    public function getTextMessageID()
    {
        return $this->TextMessageID;
    }
    /**
     * Set TextMessageID value
     * @param int $textMessageID
     * @return \StructType\TextMessageOutbox_V3
     */
    public function setTextMessageID($textMessageID = null)
    {
        // validation for constraint: int
        if (!is_null($textMessageID) && !(is_int($textMessageID) || ctype_digit($textMessageID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($textMessageID, true), gettype($textMessageID)), __LINE__);
        }
        $this->TextMessageID = $textMessageID;
        return $this;
    }
    /**
     * Get DeliveredDate value
     * @return string
     */
    public function getDeliveredDate()
    {
        return $this->DeliveredDate;
    }
    /**
     * Set DeliveredDate value
     * @param string $deliveredDate
     * @return \StructType\TextMessageOutbox_V3
     */
    public function setDeliveredDate($deliveredDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveredDate) && !is_string($deliveredDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveredDate, true), gettype($deliveredDate)), __LINE__);
        }
        $this->DeliveredDate = $deliveredDate;
        return $this;
    }
    /**
     * Get CreationDate value
     * @return string
     */
    public function getCreationDate()
    {
        return $this->CreationDate;
    }
    /**
     * Set CreationDate value
     * @param string $creationDate
     * @return \StructType\TextMessageOutbox_V3
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        $this->CreationDate = $creationDate;
        return $this;
    }
    /**
     * Get ModifiedDate value
     * @return string
     */
    public function getModifiedDate()
    {
        return $this->ModifiedDate;
    }
    /**
     * Set ModifiedDate value
     * @param string $modifiedDate
     * @return \StructType\TextMessageOutbox_V3
     */
    public function setModifiedDate($modifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($modifiedDate) && !is_string($modifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modifiedDate, true), gettype($modifiedDate)), __LINE__);
        }
        $this->ModifiedDate = $modifiedDate;
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * @return string
     */
    public function getArrivalDateTime()
    {
        return $this->ArrivalDateTime;
    }
    /**
     * Set ArrivalDateTime value
     * @param string $arrivalDateTime
     * @return \StructType\TextMessageOutbox_V3
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDateTime) && !is_string($arrivalDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDateTime, true), gettype($arrivalDateTime)), __LINE__);
        }
        $this->ArrivalDateTime = $arrivalDateTime;
        return $this;
    }
    /**
     * Get Read value
     * @return bool
     */
    public function getRead()
    {
        return $this->Read;
    }
    /**
     * Set Read value
     * @param bool $read
     * @return \StructType\TextMessageOutbox_V3
     */
    public function setRead($read = null)
    {
        // validation for constraint: boolean
        if (!is_null($read) && !is_bool($read)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($read, true), gettype($read)), __LINE__);
        }
        $this->Read = $read;
        return $this;
    }
    /**
     * Get ReadDate value
     * @return string
     */
    public function getReadDate()
    {
        return $this->ReadDate;
    }
    /**
     * Set ReadDate value
     * @param string $readDate
     * @return \StructType\TextMessageOutbox_V3
     */
    public function setReadDate($readDate = null)
    {
        // validation for constraint: string
        if (!is_null($readDate) && !is_string($readDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($readDate, true), gettype($readDate)), __LINE__);
        }
        $this->ReadDate = $readDate;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\EnumTextMessageStatus::valueIsValid()
     * @uses \EnumType\EnumTextMessageStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\TextMessageOutbox_V3
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTextMessageStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumTextMessageStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\EnumTextMessageStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ForceOBCWakeUp value
     * @return bool
     */
    public function getForceOBCWakeUp()
    {
        return $this->ForceOBCWakeUp;
    }
    /**
     * Set ForceOBCWakeUp value
     * @param bool $forceOBCWakeUp
     * @return \StructType\TextMessageOutbox_V3
     */
    public function setForceOBCWakeUp($forceOBCWakeUp = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceOBCWakeUp) && !is_bool($forceOBCWakeUp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forceOBCWakeUp, true), gettype($forceOBCWakeUp)), __LINE__);
        }
        $this->ForceOBCWakeUp = $forceOBCWakeUp;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\TextMessageOutbox_V3
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierVehicleResult $trailer
     * @return \StructType\TextMessageOutbox_V3
     */
    public function setTrailer(\StructType\IdentifierVehicleResult $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\TextMessageOutbox_V3
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Dispatcher value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDispatcher()
    {
        return $this->Dispatcher;
    }
    /**
     * Set Dispatcher value
     * @param \StructType\IdentifierPerson $dispatcher
     * @return \StructType\TextMessageOutbox_V3
     */
    public function setDispatcher(\StructType\IdentifierPerson $dispatcher = null)
    {
        $this->Dispatcher = $dispatcher;
        return $this;
    }
    /**
     * Get InboxMessageRepliedFrom value
     * @return \StructType\TextMessageInbox_V3|null
     */
    public function getInboxMessageRepliedFrom()
    {
        return $this->InboxMessageRepliedFrom;
    }
    /**
     * Set InboxMessageRepliedFrom value
     * @param \StructType\TextMessageInbox_V3 $inboxMessageRepliedFrom
     * @return \StructType\TextMessageOutbox_V3
     */
    public function setInboxMessageRepliedFrom(\StructType\TextMessageInbox_V3 $inboxMessageRepliedFrom = null)
    {
        $this->InboxMessageRepliedFrom = $inboxMessageRepliedFrom;
        return $this;
    }
    /**
     * Get RepliesOnOutboxMessage value
     * @return \ArrayType\ArrayOfTextMessageInbox_V3|null
     */
    public function getRepliesOnOutboxMessage()
    {
        return $this->RepliesOnOutboxMessage;
    }
    /**
     * Set RepliesOnOutboxMessage value
     * @param \ArrayType\ArrayOfTextMessageInbox_V3 $repliesOnOutboxMessage
     * @return \StructType\TextMessageOutbox_V3
     */
    public function setRepliesOnOutboxMessage(\ArrayType\ArrayOfTextMessageInbox_V3 $repliesOnOutboxMessage = null)
    {
        $this->RepliesOnOutboxMessage = $repliesOnOutboxMessage;
        return $this;
    }
}
