<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TemperatureResult StructType
 * @subpackage Structs
 */
class TemperatureResult extends AbstractStructBase
{
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Measurements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTemperatureMeasurement
     */
    public $Measurements;
    /**
     * Constructor method for TemperatureResult
     * @uses TemperatureResult::setVehicle()
     * @uses TemperatureResult::setMeasurements()
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \ArrayType\ArrayOfTemperatureMeasurement $measurements
     */
    public function __construct(\StructType\IdentifierVehicleResult $vehicle = null, \ArrayType\ArrayOfTemperatureMeasurement $measurements = null)
    {
        $this
            ->setVehicle($vehicle)
            ->setMeasurements($measurements);
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\TemperatureResult
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Measurements value
     * @return \ArrayType\ArrayOfTemperatureMeasurement|null
     */
    public function getMeasurements()
    {
        return $this->Measurements;
    }
    /**
     * Set Measurements value
     * @param \ArrayType\ArrayOfTemperatureMeasurement $measurements
     * @return \StructType\TemperatureResult
     */
    public function setMeasurements(\ArrayType\ArrayOfTemperatureMeasurement $measurements = null)
    {
        $this->Measurements = $measurements;
        return $this;
    }
}
