<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TelemetricDataItem StructType
 * @subpackage Structs
 */
class TelemetricDataItem extends AbstractStructBase
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Date;
    /**
     * The Kilometers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Kilometers;
    /**
     * The Speed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Speed;
    /**
     * The DateReceived
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DateReceived;
    /**
     * The ModificationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ModificationID;
    /**
     * The Ignition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactObject
     */
    public $Ignition;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult_V2
     */
    public $Vehicle;
    /**
     * The Trailer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierTrailerResult
     */
    public $Trailer;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $Driver;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionResult
     */
    public $Position;
    /**
     * The GenericList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfGenericItem
     */
    public $GenericList;
    /**
     * The Temperatures
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TemperatureObject
     */
    public $Temperatures;
    /**
     * The TachoInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CodeInfo
     */
    public $TachoInfo;
    /**
     * The EBS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EbsObject
     */
    public $EBS;
    /**
     * The Reefer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ReeferObject
     */
    public $Reefer;
    /**
     * The DoorContacts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DoorContacts
     */
    public $DoorContacts;
    /**
     * Constructor method for TelemetricDataItem
     * @uses TelemetricDataItem::setDate()
     * @uses TelemetricDataItem::setKilometers()
     * @uses TelemetricDataItem::setSpeed()
     * @uses TelemetricDataItem::setDateReceived()
     * @uses TelemetricDataItem::setModificationID()
     * @uses TelemetricDataItem::setIgnition()
     * @uses TelemetricDataItem::setVehicle()
     * @uses TelemetricDataItem::setTrailer()
     * @uses TelemetricDataItem::setDriver()
     * @uses TelemetricDataItem::setPosition()
     * @uses TelemetricDataItem::setGenericList()
     * @uses TelemetricDataItem::setTemperatures()
     * @uses TelemetricDataItem::setTachoInfo()
     * @uses TelemetricDataItem::setEBS()
     * @uses TelemetricDataItem::setReefer()
     * @uses TelemetricDataItem::setDoorContacts()
     * @param string $date
     * @param int $kilometers
     * @param float $speed
     * @param string $dateReceived
     * @param int $modificationID
     * @param \StructType\ContactObject $ignition
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @param \StructType\IdentifierTrailerResult $trailer
     * @param \StructType\IdentifierPerson_V2 $driver
     * @param \StructType\PositionResult $position
     * @param \ArrayType\ArrayOfGenericItem $genericList
     * @param \StructType\TemperatureObject $temperatures
     * @param \StructType\CodeInfo $tachoInfo
     * @param \StructType\EbsObject $eBS
     * @param \StructType\ReeferObject $reefer
     * @param \StructType\DoorContacts $doorContacts
     */
    public function __construct($date = null, $kilometers = null, $speed = null, $dateReceived = null, $modificationID = null, \StructType\ContactObject $ignition = null, \StructType\IdentifierVehicleResult_V2 $vehicle = null, \StructType\IdentifierTrailerResult $trailer = null, \StructType\IdentifierPerson_V2 $driver = null, \StructType\PositionResult $position = null, \ArrayType\ArrayOfGenericItem $genericList = null, \StructType\TemperatureObject $temperatures = null, \StructType\CodeInfo $tachoInfo = null, \StructType\EbsObject $eBS = null, \StructType\ReeferObject $reefer = null, \StructType\DoorContacts $doorContacts = null)
    {
        $this
            ->setDate($date)
            ->setKilometers($kilometers)
            ->setSpeed($speed)
            ->setDateReceived($dateReceived)
            ->setModificationID($modificationID)
            ->setIgnition($ignition)
            ->setVehicle($vehicle)
            ->setTrailer($trailer)
            ->setDriver($driver)
            ->setPosition($position)
            ->setGenericList($genericList)
            ->setTemperatures($temperatures)
            ->setTachoInfo($tachoInfo)
            ->setEBS($eBS)
            ->setReefer($reefer)
            ->setDoorContacts($doorContacts);
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\TelemetricDataItem
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Kilometers value
     * @return int
     */
    public function getKilometers()
    {
        return $this->Kilometers;
    }
    /**
     * Set Kilometers value
     * @param int $kilometers
     * @return \StructType\TelemetricDataItem
     */
    public function setKilometers($kilometers = null)
    {
        // validation for constraint: int
        if (!is_null($kilometers) && !(is_int($kilometers) || ctype_digit($kilometers))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kilometers, true), gettype($kilometers)), __LINE__);
        }
        $this->Kilometers = $kilometers;
        return $this;
    }
    /**
     * Get Speed value
     * @return float
     */
    public function getSpeed()
    {
        return $this->Speed;
    }
    /**
     * Set Speed value
     * @param float $speed
     * @return \StructType\TelemetricDataItem
     */
    public function setSpeed($speed = null)
    {
        // validation for constraint: float
        if (!is_null($speed) && !(is_float($speed) || is_numeric($speed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($speed, true), gettype($speed)), __LINE__);
        }
        $this->Speed = $speed;
        return $this;
    }
    /**
     * Get DateReceived value
     * @return string
     */
    public function getDateReceived()
    {
        return $this->DateReceived;
    }
    /**
     * Set DateReceived value
     * @param string $dateReceived
     * @return \StructType\TelemetricDataItem
     */
    public function setDateReceived($dateReceived = null)
    {
        // validation for constraint: string
        if (!is_null($dateReceived) && !is_string($dateReceived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateReceived, true), gettype($dateReceived)), __LINE__);
        }
        $this->DateReceived = $dateReceived;
        return $this;
    }
    /**
     * Get ModificationID value
     * @return int
     */
    public function getModificationID()
    {
        return $this->ModificationID;
    }
    /**
     * Set ModificationID value
     * @param int $modificationID
     * @return \StructType\TelemetricDataItem
     */
    public function setModificationID($modificationID = null)
    {
        // validation for constraint: int
        if (!is_null($modificationID) && !(is_int($modificationID) || ctype_digit($modificationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($modificationID, true), gettype($modificationID)), __LINE__);
        }
        $this->ModificationID = $modificationID;
        return $this;
    }
    /**
     * Get Ignition value
     * @return \StructType\ContactObject|null
     */
    public function getIgnition()
    {
        return $this->Ignition;
    }
    /**
     * Set Ignition value
     * @param \StructType\ContactObject $ignition
     * @return \StructType\TelemetricDataItem
     */
    public function setIgnition(\StructType\ContactObject $ignition = null)
    {
        $this->Ignition = $ignition;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult_V2|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @return \StructType\TelemetricDataItem
     */
    public function setVehicle(\StructType\IdentifierVehicleResult_V2 $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierTrailerResult|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierTrailerResult $trailer
     * @return \StructType\TelemetricDataItem
     */
    public function setTrailer(\StructType\IdentifierTrailerResult $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson_V2 $driver
     * @return \StructType\TelemetricDataItem
     */
    public function setDriver(\StructType\IdentifierPerson_V2 $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\PositionResult|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\PositionResult $position
     * @return \StructType\TelemetricDataItem
     */
    public function setPosition(\StructType\PositionResult $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get GenericList value
     * @return \ArrayType\ArrayOfGenericItem|null
     */
    public function getGenericList()
    {
        return $this->GenericList;
    }
    /**
     * Set GenericList value
     * @param \ArrayType\ArrayOfGenericItem $genericList
     * @return \StructType\TelemetricDataItem
     */
    public function setGenericList(\ArrayType\ArrayOfGenericItem $genericList = null)
    {
        $this->GenericList = $genericList;
        return $this;
    }
    /**
     * Get Temperatures value
     * @return \StructType\TemperatureObject|null
     */
    public function getTemperatures()
    {
        return $this->Temperatures;
    }
    /**
     * Set Temperatures value
     * @param \StructType\TemperatureObject $temperatures
     * @return \StructType\TelemetricDataItem
     */
    public function setTemperatures(\StructType\TemperatureObject $temperatures = null)
    {
        $this->Temperatures = $temperatures;
        return $this;
    }
    /**
     * Get TachoInfo value
     * @return \StructType\CodeInfo|null
     */
    public function getTachoInfo()
    {
        return $this->TachoInfo;
    }
    /**
     * Set TachoInfo value
     * @param \StructType\CodeInfo $tachoInfo
     * @return \StructType\TelemetricDataItem
     */
    public function setTachoInfo(\StructType\CodeInfo $tachoInfo = null)
    {
        $this->TachoInfo = $tachoInfo;
        return $this;
    }
    /**
     * Get EBS value
     * @return \StructType\EbsObject|null
     */
    public function getEBS()
    {
        return $this->EBS;
    }
    /**
     * Set EBS value
     * @param \StructType\EbsObject $eBS
     * @return \StructType\TelemetricDataItem
     */
    public function setEBS(\StructType\EbsObject $eBS = null)
    {
        $this->EBS = $eBS;
        return $this;
    }
    /**
     * Get Reefer value
     * @return \StructType\ReeferObject|null
     */
    public function getReefer()
    {
        return $this->Reefer;
    }
    /**
     * Set Reefer value
     * @param \StructType\ReeferObject $reefer
     * @return \StructType\TelemetricDataItem
     */
    public function setReefer(\StructType\ReeferObject $reefer = null)
    {
        $this->Reefer = $reefer;
        return $this;
    }
    /**
     * Get DoorContacts value
     * @return \StructType\DoorContacts|null
     */
    public function getDoorContacts()
    {
        return $this->DoorContacts;
    }
    /**
     * Set DoorContacts value
     * @param \StructType\DoorContacts $doorContacts
     * @return \StructType\TelemetricDataItem
     */
    public function setDoorContacts(\StructType\DoorContacts $doorContacts = null)
    {
        $this->DoorContacts = $doorContacts;
        return $this;
    }
}
