<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TachoDataSummary StructType
 * @subpackage Structs
 */
class TachoDataSummary extends AbstractStructBase
{
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Duration;
    /**
     * The WorkingCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CodeInfo
     */
    public $WorkingCode;
    /**
     * Constructor method for TachoDataSummary
     * @uses TachoDataSummary::setDuration()
     * @uses TachoDataSummary::setWorkingCode()
     * @param int $duration
     * @param \StructType\CodeInfo $workingCode
     */
    public function __construct($duration = null, \StructType\CodeInfo $workingCode = null)
    {
        $this
            ->setDuration($duration)
            ->setWorkingCode($workingCode);
    }
    /**
     * Get Duration value
     * @return int
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param int $duration
     * @return \StructType\TachoDataSummary
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !(is_int($duration) || ctype_digit($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get WorkingCode value
     * @return \StructType\CodeInfo|null
     */
    public function getWorkingCode()
    {
        return $this->WorkingCode;
    }
    /**
     * Set WorkingCode value
     * @param \StructType\CodeInfo $workingCode
     * @return \StructType\TachoDataSummary
     */
    public function setWorkingCode(\StructType\CodeInfo $workingCode = null)
    {
        $this->WorkingCode = $workingCode;
        return $this;
    }
}
