<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ScannedDocumentsSelection StructType
 * @subpackage Structs
 */
class ScannedDocumentsSelection extends AbstractStructBase
{
    /**
     * The ScanID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ScanID;
    /**
     * The SelectionFromToday
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeSelection
     */
    public $SelectionFromToday;
    /**
     * The SelectionDateRange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeRangeSelection
     */
    public $SelectionDateRange;
    /**
     * Constructor method for ScannedDocumentsSelection
     * @uses ScannedDocumentsSelection::setScanID()
     * @uses ScannedDocumentsSelection::setSelectionFromToday()
     * @uses ScannedDocumentsSelection::setSelectionDateRange()
     * @param int $scanID
     * @param \StructType\DateTimeSelection $selectionFromToday
     * @param \StructType\DateTimeRangeSelection $selectionDateRange
     */
    public function __construct($scanID = null, \StructType\DateTimeSelection $selectionFromToday = null, \StructType\DateTimeRangeSelection $selectionDateRange = null)
    {
        $this
            ->setScanID($scanID)
            ->setSelectionFromToday($selectionFromToday)
            ->setSelectionDateRange($selectionDateRange);
    }
    /**
     * Get ScanID value
     * @return int
     */
    public function getScanID()
    {
        return $this->ScanID;
    }
    /**
     * Set ScanID value
     * @param int $scanID
     * @return \StructType\ScannedDocumentsSelection
     */
    public function setScanID($scanID = null)
    {
        // validation for constraint: int
        if (!is_null($scanID) && !(is_int($scanID) || ctype_digit($scanID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($scanID, true), gettype($scanID)), __LINE__);
        }
        $this->ScanID = $scanID;
        return $this;
    }
    /**
     * Get SelectionFromToday value
     * @return \StructType\DateTimeSelection|null
     */
    public function getSelectionFromToday()
    {
        return $this->SelectionFromToday;
    }
    /**
     * Set SelectionFromToday value
     * @param \StructType\DateTimeSelection $selectionFromToday
     * @return \StructType\ScannedDocumentsSelection
     */
    public function setSelectionFromToday(\StructType\DateTimeSelection $selectionFromToday = null)
    {
        $this->SelectionFromToday = $selectionFromToday;
        return $this;
    }
    /**
     * Get SelectionDateRange value
     * @return \StructType\DateTimeRangeSelection|null
     */
    public function getSelectionDateRange()
    {
        return $this->SelectionDateRange;
    }
    /**
     * Set SelectionDateRange value
     * @param \StructType\DateTimeRangeSelection $selectionDateRange
     * @return \StructType\ScannedDocumentsSelection
     */
    public function setSelectionDateRange(\StructType\DateTimeRangeSelection $selectionDateRange = null)
    {
        $this->SelectionDateRange = $selectionDateRange;
        return $this;
    }
}
