<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ScannedDocumentSelection StructType
 * @subpackage Structs
 */
class ScannedDocumentSelection extends AbstractStructBase
{
    /**
     * The ScanID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ScanID;
    /**
     * The PageNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PageNumber;
    /**
     * The ConvertToPdf
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ConvertToPdf;
    /**
     * Constructor method for ScannedDocumentSelection
     * @uses ScannedDocumentSelection::setScanID()
     * @uses ScannedDocumentSelection::setPageNumber()
     * @uses ScannedDocumentSelection::setConvertToPdf()
     * @param int $scanID
     * @param int $pageNumber
     * @param bool $convertToPdf
     */
    public function __construct($scanID = null, $pageNumber = null, $convertToPdf = null)
    {
        $this
            ->setScanID($scanID)
            ->setPageNumber($pageNumber)
            ->setConvertToPdf($convertToPdf);
    }
    /**
     * Get ScanID value
     * @return int
     */
    public function getScanID()
    {
        return $this->ScanID;
    }
    /**
     * Set ScanID value
     * @param int $scanID
     * @return \StructType\ScannedDocumentSelection
     */
    public function setScanID($scanID = null)
    {
        // validation for constraint: int
        if (!is_null($scanID) && !(is_int($scanID) || ctype_digit($scanID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($scanID, true), gettype($scanID)), __LINE__);
        }
        $this->ScanID = $scanID;
        return $this;
    }
    /**
     * Get PageNumber value
     * @return int
     */
    public function getPageNumber()
    {
        return $this->PageNumber;
    }
    /**
     * Set PageNumber value
     * @param int $pageNumber
     * @return \StructType\ScannedDocumentSelection
     */
    public function setPageNumber($pageNumber = null)
    {
        // validation for constraint: int
        if (!is_null($pageNumber) && !(is_int($pageNumber) || ctype_digit($pageNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageNumber, true), gettype($pageNumber)), __LINE__);
        }
        $this->PageNumber = $pageNumber;
        return $this;
    }
    /**
     * Get ConvertToPdf value
     * @return bool
     */
    public function getConvertToPdf()
    {
        return $this->ConvertToPdf;
    }
    /**
     * Set ConvertToPdf value
     * @param bool $convertToPdf
     * @return \StructType\ScannedDocumentSelection
     */
    public function setConvertToPdf($convertToPdf = null)
    {
        // validation for constraint: boolean
        if (!is_null($convertToPdf) && !is_bool($convertToPdf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($convertToPdf, true), gettype($convertToPdf)), __LINE__);
        }
        $this->ConvertToPdf = $convertToPdf;
        return $this;
    }
}
