<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveResourcesFromGroup StructType
 * @subpackage Structs
 */
class RemoveResourcesFromGroup extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * The GroupCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupCode;
    /**
     * The SubGroupCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubGroupCode;
    /**
     * The Resources
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfResourceIdentifier
     */
    public $Resources;
    /**
     * Constructor method for RemoveResourcesFromGroup
     * @uses RemoveResourcesFromGroup::setType()
     * @uses RemoveResourcesFromGroup::setGroupCode()
     * @uses RemoveResourcesFromGroup::setSubGroupCode()
     * @uses RemoveResourcesFromGroup::setResources()
     * @param string $type
     * @param string $groupCode
     * @param string $subGroupCode
     * @param \ArrayType\ArrayOfResourceIdentifier $resources
     */
    public function __construct($type = null, $groupCode = null, $subGroupCode = null, \ArrayType\ArrayOfResourceIdentifier $resources = null)
    {
        $this
            ->setType($type)
            ->setGroupCode($groupCode)
            ->setSubGroupCode($subGroupCode)
            ->setResources($resources);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\GroupTypeV2::valueIsValid()
     * @uses \EnumType\GroupTypeV2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\RemoveResourcesFromGroup
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GroupTypeV2::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\GroupTypeV2', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\GroupTypeV2::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get GroupCode value
     * @return string|null
     */
    public function getGroupCode()
    {
        return $this->GroupCode;
    }
    /**
     * Set GroupCode value
     * @param string $groupCode
     * @return \StructType\RemoveResourcesFromGroup
     */
    public function setGroupCode($groupCode = null)
    {
        // validation for constraint: string
        if (!is_null($groupCode) && !is_string($groupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupCode, true), gettype($groupCode)), __LINE__);
        }
        $this->GroupCode = $groupCode;
        return $this;
    }
    /**
     * Get SubGroupCode value
     * @return string|null
     */
    public function getSubGroupCode()
    {
        return $this->SubGroupCode;
    }
    /**
     * Set SubGroupCode value
     * @param string $subGroupCode
     * @return \StructType\RemoveResourcesFromGroup
     */
    public function setSubGroupCode($subGroupCode = null)
    {
        // validation for constraint: string
        if (!is_null($subGroupCode) && !is_string($subGroupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subGroupCode, true), gettype($subGroupCode)), __LINE__);
        }
        $this->SubGroupCode = $subGroupCode;
        return $this;
    }
    /**
     * Get Resources value
     * @return \ArrayType\ArrayOfResourceIdentifier|null
     */
    public function getResources()
    {
        return $this->Resources;
    }
    /**
     * Set Resources value
     * @param \ArrayType\ArrayOfResourceIdentifier $resources
     * @return \StructType\RemoveResourcesFromGroup
     */
    public function setResources(\ArrayType\ArrayOfResourceIdentifier $resources = null)
    {
        $this->Resources = $resources;
        return $this;
    }
}
