<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveDriverFromGroup StructType
 * @subpackage Structs
 */
class RemoveDriverFromGroup extends AbstractStructBase
{
    /**
     * The GroupSoftwareType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GroupSoftwareType;
    /**
     * The From
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $From;
    /**
     * The GroupCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupCode;
    /**
     * The SubGroupCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubGroupCode;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Identifier
     */
    public $Driver;
    /**
     * Constructor method for RemoveDriverFromGroup
     * @uses RemoveDriverFromGroup::setGroupSoftwareType()
     * @uses RemoveDriverFromGroup::setFrom()
     * @uses RemoveDriverFromGroup::setGroupCode()
     * @uses RemoveDriverFromGroup::setSubGroupCode()
     * @uses RemoveDriverFromGroup::setDriver()
     * @param string $groupSoftwareType
     * @param string $from
     * @param string $groupCode
     * @param string $subGroupCode
     * @param \StructType\Identifier $driver
     */
    public function __construct($groupSoftwareType = null, $from = null, $groupCode = null, $subGroupCode = null, \StructType\Identifier $driver = null)
    {
        $this
            ->setGroupSoftwareType($groupSoftwareType)
            ->setFrom($from)
            ->setGroupCode($groupCode)
            ->setSubGroupCode($subGroupCode)
            ->setDriver($driver);
    }
    /**
     * Get GroupSoftwareType value
     * @return string
     */
    public function getGroupSoftwareType()
    {
        return $this->GroupSoftwareType;
    }
    /**
     * Set GroupSoftwareType value
     * @uses \EnumType\EnumGroupSoftwareType::valueIsValid()
     * @uses \EnumType\EnumGroupSoftwareType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $groupSoftwareType
     * @return \StructType\RemoveDriverFromGroup
     */
    public function setGroupSoftwareType($groupSoftwareType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumGroupSoftwareType::valueIsValid($groupSoftwareType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumGroupSoftwareType', is_array($groupSoftwareType) ? implode(', ', $groupSoftwareType) : var_export($groupSoftwareType, true), implode(', ', \EnumType\EnumGroupSoftwareType::getValidValues())), __LINE__);
        }
        $this->GroupSoftwareType = $groupSoftwareType;
        return $this;
    }
    /**
     * Get From value
     * @return string
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param string $from
     * @return \StructType\RemoveDriverFromGroup
     */
    public function setFrom($from = null)
    {
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from, true), gettype($from)), __LINE__);
        }
        $this->From = $from;
        return $this;
    }
    /**
     * Get GroupCode value
     * @return string|null
     */
    public function getGroupCode()
    {
        return $this->GroupCode;
    }
    /**
     * Set GroupCode value
     * @param string $groupCode
     * @return \StructType\RemoveDriverFromGroup
     */
    public function setGroupCode($groupCode = null)
    {
        // validation for constraint: string
        if (!is_null($groupCode) && !is_string($groupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupCode, true), gettype($groupCode)), __LINE__);
        }
        $this->GroupCode = $groupCode;
        return $this;
    }
    /**
     * Get SubGroupCode value
     * @return string|null
     */
    public function getSubGroupCode()
    {
        return $this->SubGroupCode;
    }
    /**
     * Set SubGroupCode value
     * @param string $subGroupCode
     * @return \StructType\RemoveDriverFromGroup
     */
    public function setSubGroupCode($subGroupCode = null)
    {
        // validation for constraint: string
        if (!is_null($subGroupCode) && !is_string($subGroupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subGroupCode, true), gettype($subGroupCode)), __LINE__);
        }
        $this->SubGroupCode = $subGroupCode;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\Identifier|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\Identifier $driver
     * @return \StructType\RemoveDriverFromGroup
     */
    public function setDriver(\StructType\Identifier $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
}
