<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemainingTimeItemMin_V3 StructType
 * @subpackage Structs
 */
class RemainingTimeItemMin_V3 extends RemainingTimeItemMin_V2
{
    /**
     * The CompensationDoneOn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CompensationDoneOn;
    /**
     * The CompensationDeadline
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CompensationDeadline;
    /**
     * The NextMinimumWeeklyRest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NextMinimumWeeklyRest;
    /**
     * Constructor method for RemainingTimeItemMin_V3
     * @uses RemainingTimeItemMin_V3::setCompensationDoneOn()
     * @uses RemainingTimeItemMin_V3::setCompensationDeadline()
     * @uses RemainingTimeItemMin_V3::setNextMinimumWeeklyRest()
     * @param string $compensationDoneOn
     * @param string $compensationDeadline
     * @param int $nextMinimumWeeklyRest
     */
    public function __construct($compensationDoneOn = null, $compensationDeadline = null, $nextMinimumWeeklyRest = null)
    {
        $this
            ->setCompensationDoneOn($compensationDoneOn)
            ->setCompensationDeadline($compensationDeadline)
            ->setNextMinimumWeeklyRest($nextMinimumWeeklyRest);
    }
    /**
     * Get CompensationDoneOn value
     * @return string
     */
    public function getCompensationDoneOn()
    {
        return $this->CompensationDoneOn;
    }
    /**
     * Set CompensationDoneOn value
     * @param string $compensationDoneOn
     * @return \StructType\RemainingTimeItemMin_V3
     */
    public function setCompensationDoneOn($compensationDoneOn = null)
    {
        // validation for constraint: string
        if (!is_null($compensationDoneOn) && !is_string($compensationDoneOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($compensationDoneOn, true), gettype($compensationDoneOn)), __LINE__);
        }
        $this->CompensationDoneOn = $compensationDoneOn;
        return $this;
    }
    /**
     * Get CompensationDeadline value
     * @return string
     */
    public function getCompensationDeadline()
    {
        return $this->CompensationDeadline;
    }
    /**
     * Set CompensationDeadline value
     * @param string $compensationDeadline
     * @return \StructType\RemainingTimeItemMin_V3
     */
    public function setCompensationDeadline($compensationDeadline = null)
    {
        // validation for constraint: string
        if (!is_null($compensationDeadline) && !is_string($compensationDeadline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($compensationDeadline, true), gettype($compensationDeadline)), __LINE__);
        }
        $this->CompensationDeadline = $compensationDeadline;
        return $this;
    }
    /**
     * Get NextMinimumWeeklyRest value
     * @return int
     */
    public function getNextMinimumWeeklyRest()
    {
        return $this->NextMinimumWeeklyRest;
    }
    /**
     * Set NextMinimumWeeklyRest value
     * @param int $nextMinimumWeeklyRest
     * @return \StructType\RemainingTimeItemMin_V3
     */
    public function setNextMinimumWeeklyRest($nextMinimumWeeklyRest = null)
    {
        // validation for constraint: int
        if (!is_null($nextMinimumWeeklyRest) && !(is_int($nextMinimumWeeklyRest) || ctype_digit($nextMinimumWeeklyRest))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nextMinimumWeeklyRest, true), gettype($nextMinimumWeeklyRest)), __LINE__);
        }
        $this->NextMinimumWeeklyRest = $nextMinimumWeeklyRest;
        return $this;
    }
}
