<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Reference StructType
 * @subpackage Structs
 */
class Reference extends AbstractStructBase
{
    /**
     * The Partner
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Partner;
    /**
     * The InternalReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InternalReference;
    /**
     * The PartnerReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerReference;
    /**
     * Constructor method for Reference
     * @uses Reference::setPartner()
     * @uses Reference::setInternalReference()
     * @uses Reference::setPartnerReference()
     * @param string $partner
     * @param string $internalReference
     * @param string $partnerReference
     */
    public function __construct($partner = null, $internalReference = null, $partnerReference = null)
    {
        $this
            ->setPartner($partner)
            ->setInternalReference($internalReference)
            ->setPartnerReference($partnerReference);
    }
    /**
     * Get Partner value
     * @return string|null
     */
    public function getPartner()
    {
        return $this->Partner;
    }
    /**
     * Set Partner value
     * @param string $partner
     * @return \StructType\Reference
     */
    public function setPartner($partner = null)
    {
        // validation for constraint: string
        if (!is_null($partner) && !is_string($partner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partner, true), gettype($partner)), __LINE__);
        }
        $this->Partner = $partner;
        return $this;
    }
    /**
     * Get InternalReference value
     * @return string|null
     */
    public function getInternalReference()
    {
        return $this->InternalReference;
    }
    /**
     * Set InternalReference value
     * @param string $internalReference
     * @return \StructType\Reference
     */
    public function setInternalReference($internalReference = null)
    {
        // validation for constraint: string
        if (!is_null($internalReference) && !is_string($internalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalReference, true), gettype($internalReference)), __LINE__);
        }
        $this->InternalReference = $internalReference;
        return $this;
    }
    /**
     * Get PartnerReference value
     * @return string|null
     */
    public function getPartnerReference()
    {
        return $this->PartnerReference;
    }
    /**
     * Set PartnerReference value
     * @param string $partnerReference
     * @return \StructType\Reference
     */
    public function setPartnerReference($partnerReference = null)
    {
        // validation for constraint: string
        if (!is_null($partnerReference) && !is_string($partnerReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerReference, true), gettype($partnerReference)), __LINE__);
        }
        $this->PartnerReference = $partnerReference;
        return $this;
    }
}
