<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReeferObject StructType
 * @subpackage Structs
 */
class ReeferObject extends AbstractStructBase
{
    /**
     * The FuelLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $FuelLevel;
    /**
     * The EngineState
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $EngineState;
    /**
     * The PowerOn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $PowerOn;
    /**
     * The BatteryVoltage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $BatteryVoltage;
    /**
     * The AlarmStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $AlarmStatus;
    /**
     * The Defrost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Defrost;
    /**
     * The OperatingHours
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $OperatingHours;
    /**
     * The OperatingMode1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OperatingMode1;
    /**
     * The OperatingMode2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OperatingMode2;
    /**
     * The OperatingMode3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OperatingMode3;
    /**
     * The OperatingMode4
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OperatingMode4;
    /**
     * The OverallStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OverallStatus;
    /**
     * The ExternalPowerControlStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalPowerControlStatus;
    /**
     * The IntelliSense
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntelliSense;
    /**
     * The PowerSource
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PowerSource;
    /**
     * Constructor method for ReeferObject
     * @uses ReeferObject::setFuelLevel()
     * @uses ReeferObject::setEngineState()
     * @uses ReeferObject::setPowerOn()
     * @uses ReeferObject::setBatteryVoltage()
     * @uses ReeferObject::setAlarmStatus()
     * @uses ReeferObject::setDefrost()
     * @uses ReeferObject::setOperatingHours()
     * @uses ReeferObject::setOperatingMode1()
     * @uses ReeferObject::setOperatingMode2()
     * @uses ReeferObject::setOperatingMode3()
     * @uses ReeferObject::setOperatingMode4()
     * @uses ReeferObject::setOverallStatus()
     * @uses ReeferObject::setExternalPowerControlStatus()
     * @uses ReeferObject::setIntelliSense()
     * @uses ReeferObject::setPowerSource()
     * @param float $fuelLevel
     * @param bool $engineState
     * @param bool $powerOn
     * @param float $batteryVoltage
     * @param bool $alarmStatus
     * @param bool $defrost
     * @param int $operatingHours
     * @param string $operatingMode1
     * @param string $operatingMode2
     * @param string $operatingMode3
     * @param string $operatingMode4
     * @param string $overallStatus
     * @param string $externalPowerControlStatus
     * @param string $intelliSense
     * @param string $powerSource
     */
    public function __construct($fuelLevel = null, $engineState = null, $powerOn = null, $batteryVoltage = null, $alarmStatus = null, $defrost = null, $operatingHours = null, $operatingMode1 = null, $operatingMode2 = null, $operatingMode3 = null, $operatingMode4 = null, $overallStatus = null, $externalPowerControlStatus = null, $intelliSense = null, $powerSource = null)
    {
        $this
            ->setFuelLevel($fuelLevel)
            ->setEngineState($engineState)
            ->setPowerOn($powerOn)
            ->setBatteryVoltage($batteryVoltage)
            ->setAlarmStatus($alarmStatus)
            ->setDefrost($defrost)
            ->setOperatingHours($operatingHours)
            ->setOperatingMode1($operatingMode1)
            ->setOperatingMode2($operatingMode2)
            ->setOperatingMode3($operatingMode3)
            ->setOperatingMode4($operatingMode4)
            ->setOverallStatus($overallStatus)
            ->setExternalPowerControlStatus($externalPowerControlStatus)
            ->setIntelliSense($intelliSense)
            ->setPowerSource($powerSource);
    }
    /**
     * Get FuelLevel value
     * @return float
     */
    public function getFuelLevel()
    {
        return $this->FuelLevel;
    }
    /**
     * Set FuelLevel value
     * @param float $fuelLevel
     * @return \StructType\ReeferObject
     */
    public function setFuelLevel($fuelLevel = null)
    {
        // validation for constraint: float
        if (!is_null($fuelLevel) && !(is_float($fuelLevel) || is_numeric($fuelLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fuelLevel, true), gettype($fuelLevel)), __LINE__);
        }
        $this->FuelLevel = $fuelLevel;
        return $this;
    }
    /**
     * Get EngineState value
     * @return bool
     */
    public function getEngineState()
    {
        return $this->EngineState;
    }
    /**
     * Set EngineState value
     * @param bool $engineState
     * @return \StructType\ReeferObject
     */
    public function setEngineState($engineState = null)
    {
        // validation for constraint: boolean
        if (!is_null($engineState) && !is_bool($engineState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($engineState, true), gettype($engineState)), __LINE__);
        }
        $this->EngineState = $engineState;
        return $this;
    }
    /**
     * Get PowerOn value
     * @return bool
     */
    public function getPowerOn()
    {
        return $this->PowerOn;
    }
    /**
     * Set PowerOn value
     * @param bool $powerOn
     * @return \StructType\ReeferObject
     */
    public function setPowerOn($powerOn = null)
    {
        // validation for constraint: boolean
        if (!is_null($powerOn) && !is_bool($powerOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($powerOn, true), gettype($powerOn)), __LINE__);
        }
        $this->PowerOn = $powerOn;
        return $this;
    }
    /**
     * Get BatteryVoltage value
     * @return float
     */
    public function getBatteryVoltage()
    {
        return $this->BatteryVoltage;
    }
    /**
     * Set BatteryVoltage value
     * @param float $batteryVoltage
     * @return \StructType\ReeferObject
     */
    public function setBatteryVoltage($batteryVoltage = null)
    {
        // validation for constraint: float
        if (!is_null($batteryVoltage) && !(is_float($batteryVoltage) || is_numeric($batteryVoltage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($batteryVoltage, true), gettype($batteryVoltage)), __LINE__);
        }
        $this->BatteryVoltage = $batteryVoltage;
        return $this;
    }
    /**
     * Get AlarmStatus value
     * @return bool
     */
    public function getAlarmStatus()
    {
        return $this->AlarmStatus;
    }
    /**
     * Set AlarmStatus value
     * @param bool $alarmStatus
     * @return \StructType\ReeferObject
     */
    public function setAlarmStatus($alarmStatus = null)
    {
        // validation for constraint: boolean
        if (!is_null($alarmStatus) && !is_bool($alarmStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($alarmStatus, true), gettype($alarmStatus)), __LINE__);
        }
        $this->AlarmStatus = $alarmStatus;
        return $this;
    }
    /**
     * Get Defrost value
     * @return bool
     */
    public function getDefrost()
    {
        return $this->Defrost;
    }
    /**
     * Set Defrost value
     * @param bool $defrost
     * @return \StructType\ReeferObject
     */
    public function setDefrost($defrost = null)
    {
        // validation for constraint: boolean
        if (!is_null($defrost) && !is_bool($defrost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($defrost, true), gettype($defrost)), __LINE__);
        }
        $this->Defrost = $defrost;
        return $this;
    }
    /**
     * Get OperatingHours value
     * @return int
     */
    public function getOperatingHours()
    {
        return $this->OperatingHours;
    }
    /**
     * Set OperatingHours value
     * @param int $operatingHours
     * @return \StructType\ReeferObject
     */
    public function setOperatingHours($operatingHours = null)
    {
        // validation for constraint: int
        if (!is_null($operatingHours) && !(is_int($operatingHours) || ctype_digit($operatingHours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($operatingHours, true), gettype($operatingHours)), __LINE__);
        }
        $this->OperatingHours = $operatingHours;
        return $this;
    }
    /**
     * Get OperatingMode1 value
     * @return string|null
     */
    public function getOperatingMode1()
    {
        return $this->OperatingMode1;
    }
    /**
     * Set OperatingMode1 value
     * @param string $operatingMode1
     * @return \StructType\ReeferObject
     */
    public function setOperatingMode1($operatingMode1 = null)
    {
        // validation for constraint: string
        if (!is_null($operatingMode1) && !is_string($operatingMode1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingMode1, true), gettype($operatingMode1)), __LINE__);
        }
        $this->OperatingMode1 = $operatingMode1;
        return $this;
    }
    /**
     * Get OperatingMode2 value
     * @return string|null
     */
    public function getOperatingMode2()
    {
        return $this->OperatingMode2;
    }
    /**
     * Set OperatingMode2 value
     * @param string $operatingMode2
     * @return \StructType\ReeferObject
     */
    public function setOperatingMode2($operatingMode2 = null)
    {
        // validation for constraint: string
        if (!is_null($operatingMode2) && !is_string($operatingMode2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingMode2, true), gettype($operatingMode2)), __LINE__);
        }
        $this->OperatingMode2 = $operatingMode2;
        return $this;
    }
    /**
     * Get OperatingMode3 value
     * @return string|null
     */
    public function getOperatingMode3()
    {
        return $this->OperatingMode3;
    }
    /**
     * Set OperatingMode3 value
     * @param string $operatingMode3
     * @return \StructType\ReeferObject
     */
    public function setOperatingMode3($operatingMode3 = null)
    {
        // validation for constraint: string
        if (!is_null($operatingMode3) && !is_string($operatingMode3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingMode3, true), gettype($operatingMode3)), __LINE__);
        }
        $this->OperatingMode3 = $operatingMode3;
        return $this;
    }
    /**
     * Get OperatingMode4 value
     * @return string|null
     */
    public function getOperatingMode4()
    {
        return $this->OperatingMode4;
    }
    /**
     * Set OperatingMode4 value
     * @param string $operatingMode4
     * @return \StructType\ReeferObject
     */
    public function setOperatingMode4($operatingMode4 = null)
    {
        // validation for constraint: string
        if (!is_null($operatingMode4) && !is_string($operatingMode4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingMode4, true), gettype($operatingMode4)), __LINE__);
        }
        $this->OperatingMode4 = $operatingMode4;
        return $this;
    }
    /**
     * Get OverallStatus value
     * @return string|null
     */
    public function getOverallStatus()
    {
        return $this->OverallStatus;
    }
    /**
     * Set OverallStatus value
     * @param string $overallStatus
     * @return \StructType\ReeferObject
     */
    public function setOverallStatus($overallStatus = null)
    {
        // validation for constraint: string
        if (!is_null($overallStatus) && !is_string($overallStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($overallStatus, true), gettype($overallStatus)), __LINE__);
        }
        $this->OverallStatus = $overallStatus;
        return $this;
    }
    /**
     * Get ExternalPowerControlStatus value
     * @return string|null
     */
    public function getExternalPowerControlStatus()
    {
        return $this->ExternalPowerControlStatus;
    }
    /**
     * Set ExternalPowerControlStatus value
     * @param string $externalPowerControlStatus
     * @return \StructType\ReeferObject
     */
    public function setExternalPowerControlStatus($externalPowerControlStatus = null)
    {
        // validation for constraint: string
        if (!is_null($externalPowerControlStatus) && !is_string($externalPowerControlStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalPowerControlStatus, true), gettype($externalPowerControlStatus)), __LINE__);
        }
        $this->ExternalPowerControlStatus = $externalPowerControlStatus;
        return $this;
    }
    /**
     * Get IntelliSense value
     * @return string|null
     */
    public function getIntelliSense()
    {
        return $this->IntelliSense;
    }
    /**
     * Set IntelliSense value
     * @param string $intelliSense
     * @return \StructType\ReeferObject
     */
    public function setIntelliSense($intelliSense = null)
    {
        // validation for constraint: string
        if (!is_null($intelliSense) && !is_string($intelliSense)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intelliSense, true), gettype($intelliSense)), __LINE__);
        }
        $this->IntelliSense = $intelliSense;
        return $this;
    }
    /**
     * Get PowerSource value
     * @return string|null
     */
    public function getPowerSource()
    {
        return $this->PowerSource;
    }
    /**
     * Set PowerSource value
     * @param string $powerSource
     * @return \StructType\ReeferObject
     */
    public function setPowerSource($powerSource = null)
    {
        // validation for constraint: string
        if (!is_null($powerSource) && !is_string($powerSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($powerSource, true), gettype($powerSource)), __LINE__);
        }
        $this->PowerSource = $powerSource;
        return $this;
    }
}
