<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RPMAndDurationItem StructType
 * @subpackage Structs
 */
class RPMAndDurationItem extends AbstractStructBase
{
    /**
     * The DurationInSec
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DurationInSec;
    /**
     * The DistanceInKm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DistanceInKm;
    /**
     * The FuelConsumptionInLiterPer100km
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $FuelConsumptionInLiterPer100km;
    /**
     * The FuelConsumptionInkmPerLiter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $FuelConsumptionInkmPerLiter;
    /**
     * The RPM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RPM;
    /**
     * Constructor method for RPMAndDurationItem
     * @uses RPMAndDurationItem::setDurationInSec()
     * @uses RPMAndDurationItem::setDistanceInKm()
     * @uses RPMAndDurationItem::setFuelConsumptionInLiterPer100km()
     * @uses RPMAndDurationItem::setFuelConsumptionInkmPerLiter()
     * @uses RPMAndDurationItem::setRPM()
     * @param int $durationInSec
     * @param float $distanceInKm
     * @param float $fuelConsumptionInLiterPer100km
     * @param float $fuelConsumptionInkmPerLiter
     * @param string $rPM
     */
    public function __construct($durationInSec = null, $distanceInKm = null, $fuelConsumptionInLiterPer100km = null, $fuelConsumptionInkmPerLiter = null, $rPM = null)
    {
        $this
            ->setDurationInSec($durationInSec)
            ->setDistanceInKm($distanceInKm)
            ->setFuelConsumptionInLiterPer100km($fuelConsumptionInLiterPer100km)
            ->setFuelConsumptionInkmPerLiter($fuelConsumptionInkmPerLiter)
            ->setRPM($rPM);
    }
    /**
     * Get DurationInSec value
     * @return int
     */
    public function getDurationInSec()
    {
        return $this->DurationInSec;
    }
    /**
     * Set DurationInSec value
     * @param int $durationInSec
     * @return \StructType\RPMAndDurationItem
     */
    public function setDurationInSec($durationInSec = null)
    {
        // validation for constraint: int
        if (!is_null($durationInSec) && !(is_int($durationInSec) || ctype_digit($durationInSec))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($durationInSec, true), gettype($durationInSec)), __LINE__);
        }
        $this->DurationInSec = $durationInSec;
        return $this;
    }
    /**
     * Get DistanceInKm value
     * @return float
     */
    public function getDistanceInKm()
    {
        return $this->DistanceInKm;
    }
    /**
     * Set DistanceInKm value
     * @param float $distanceInKm
     * @return \StructType\RPMAndDurationItem
     */
    public function setDistanceInKm($distanceInKm = null)
    {
        // validation for constraint: float
        if (!is_null($distanceInKm) && !(is_float($distanceInKm) || is_numeric($distanceInKm))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($distanceInKm, true), gettype($distanceInKm)), __LINE__);
        }
        $this->DistanceInKm = $distanceInKm;
        return $this;
    }
    /**
     * Get FuelConsumptionInLiterPer100km value
     * @return float
     */
    public function getFuelConsumptionInLiterPer100km()
    {
        return $this->FuelConsumptionInLiterPer100km;
    }
    /**
     * Set FuelConsumptionInLiterPer100km value
     * @param float $fuelConsumptionInLiterPer100km
     * @return \StructType\RPMAndDurationItem
     */
    public function setFuelConsumptionInLiterPer100km($fuelConsumptionInLiterPer100km = null)
    {
        // validation for constraint: float
        if (!is_null($fuelConsumptionInLiterPer100km) && !(is_float($fuelConsumptionInLiterPer100km) || is_numeric($fuelConsumptionInLiterPer100km))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fuelConsumptionInLiterPer100km, true), gettype($fuelConsumptionInLiterPer100km)), __LINE__);
        }
        $this->FuelConsumptionInLiterPer100km = $fuelConsumptionInLiterPer100km;
        return $this;
    }
    /**
     * Get FuelConsumptionInkmPerLiter value
     * @return float
     */
    public function getFuelConsumptionInkmPerLiter()
    {
        return $this->FuelConsumptionInkmPerLiter;
    }
    /**
     * Set FuelConsumptionInkmPerLiter value
     * @param float $fuelConsumptionInkmPerLiter
     * @return \StructType\RPMAndDurationItem
     */
    public function setFuelConsumptionInkmPerLiter($fuelConsumptionInkmPerLiter = null)
    {
        // validation for constraint: float
        if (!is_null($fuelConsumptionInkmPerLiter) && !(is_float($fuelConsumptionInkmPerLiter) || is_numeric($fuelConsumptionInkmPerLiter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fuelConsumptionInkmPerLiter, true), gettype($fuelConsumptionInkmPerLiter)), __LINE__);
        }
        $this->FuelConsumptionInkmPerLiter = $fuelConsumptionInkmPerLiter;
        return $this;
    }
    /**
     * Get RPM value
     * @return string|null
     */
    public function getRPM()
    {
        return $this->RPM;
    }
    /**
     * Set RPM value
     * @param string $rPM
     * @return \StructType\RPMAndDurationItem
     */
    public function setRPM($rPM = null)
    {
        // validation for constraint: string
        if (!is_null($rPM) && !is_string($rPM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPM, true), gettype($rPM)), __LINE__);
        }
        $this->RPM = $rPM;
        return $this;
    }
}
