<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductResultInsert StructType
 * @subpackage Structs
 */
class ProductResultInsert extends AbstractStructBase
{
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Action;
    /**
     * The ProductId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductId;
    /**
     * Constructor method for ProductResultInsert
     * @uses ProductResultInsert::setAction()
     * @uses ProductResultInsert::setProductId()
     * @param string $action
     * @param string $productId
     */
    public function __construct($action = null, $productId = null)
    {
        $this
            ->setAction($action)
            ->setProductId($productId);
    }
    /**
     * Get Action value
     * @return string
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \EnumType\EnumPlanningActionType::valueIsValid()
     * @uses \EnumType\EnumPlanningActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \StructType\ProductResultInsert
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumPlanningActionType::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumPlanningActionType', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \EnumType\EnumPlanningActionType::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get ProductId value
     * @return string|null
     */
    public function getProductId()
    {
        return $this->ProductId;
    }
    /**
     * Set ProductId value
     * @param string $productId
     * @return \StructType\ProductResultInsert
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->ProductId = $productId;
        return $this;
    }
}
