<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PositionSelection_V5 StructType
 * @subpackage Structs
 */
class PositionSelection_V5 extends AbstractStructBase
{
    /**
     * The DataSource
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DataSource;
    /**
     * The IncludeCodriverInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IncludeCodriverInfo;
    /**
     * The ExcludeActivities
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ExcludeActivities;
    /**
     * The Drivers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifier
     */
    public $Drivers;
    /**
     * The Vehicles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierVehicle
     */
    public $Vehicles;
    /**
     * The Trailers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierVehicle
     */
    public $Trailers;
    /**
     * The DateStrategySelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateStrategySelection
     */
    public $DateStrategySelection;
    /**
     * Constructor method for PositionSelection_V5
     * @uses PositionSelection_V5::setDataSource()
     * @uses PositionSelection_V5::setIncludeCodriverInfo()
     * @uses PositionSelection_V5::setExcludeActivities()
     * @uses PositionSelection_V5::setDrivers()
     * @uses PositionSelection_V5::setVehicles()
     * @uses PositionSelection_V5::setTrailers()
     * @uses PositionSelection_V5::setDateStrategySelection()
     * @param string $dataSource
     * @param bool $includeCodriverInfo
     * @param bool $excludeActivities
     * @param \ArrayType\ArrayOfIdentifier $drivers
     * @param \ArrayType\ArrayOfIdentifierVehicle $vehicles
     * @param \ArrayType\ArrayOfIdentifierVehicle $trailers
     * @param \StructType\DateStrategySelection $dateStrategySelection
     */
    public function __construct($dataSource = null, $includeCodriverInfo = null, $excludeActivities = null, \ArrayType\ArrayOfIdentifier $drivers = null, \ArrayType\ArrayOfIdentifierVehicle $vehicles = null, \ArrayType\ArrayOfIdentifierVehicle $trailers = null, \StructType\DateStrategySelection $dateStrategySelection = null)
    {
        $this
            ->setDataSource($dataSource)
            ->setIncludeCodriverInfo($includeCodriverInfo)
            ->setExcludeActivities($excludeActivities)
            ->setDrivers($drivers)
            ->setVehicles($vehicles)
            ->setTrailers($trailers)
            ->setDateStrategySelection($dateStrategySelection);
    }
    /**
     * Get DataSource value
     * @return string
     */
    public function getDataSource()
    {
        return $this->DataSource;
    }
    /**
     * Set DataSource value
     * @uses \EnumType\PositionDataSource::valueIsValid()
     * @uses \EnumType\PositionDataSource::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dataSource
     * @return \StructType\PositionSelection_V5
     */
    public function setDataSource($dataSource = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PositionDataSource::valueIsValid($dataSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PositionDataSource', is_array($dataSource) ? implode(', ', $dataSource) : var_export($dataSource, true), implode(', ', \EnumType\PositionDataSource::getValidValues())), __LINE__);
        }
        $this->DataSource = $dataSource;
        return $this;
    }
    /**
     * Get IncludeCodriverInfo value
     * @return bool
     */
    public function getIncludeCodriverInfo()
    {
        return $this->IncludeCodriverInfo;
    }
    /**
     * Set IncludeCodriverInfo value
     * @param bool $includeCodriverInfo
     * @return \StructType\PositionSelection_V5
     */
    public function setIncludeCodriverInfo($includeCodriverInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeCodriverInfo) && !is_bool($includeCodriverInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeCodriverInfo, true), gettype($includeCodriverInfo)), __LINE__);
        }
        $this->IncludeCodriverInfo = $includeCodriverInfo;
        return $this;
    }
    /**
     * Get ExcludeActivities value
     * @return bool
     */
    public function getExcludeActivities()
    {
        return $this->ExcludeActivities;
    }
    /**
     * Set ExcludeActivities value
     * @param bool $excludeActivities
     * @return \StructType\PositionSelection_V5
     */
    public function setExcludeActivities($excludeActivities = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeActivities) && !is_bool($excludeActivities)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeActivities, true), gettype($excludeActivities)), __LINE__);
        }
        $this->ExcludeActivities = $excludeActivities;
        return $this;
    }
    /**
     * Get Drivers value
     * @return \ArrayType\ArrayOfIdentifier|null
     */
    public function getDrivers()
    {
        return $this->Drivers;
    }
    /**
     * Set Drivers value
     * @param \ArrayType\ArrayOfIdentifier $drivers
     * @return \StructType\PositionSelection_V5
     */
    public function setDrivers(\ArrayType\ArrayOfIdentifier $drivers = null)
    {
        $this->Drivers = $drivers;
        return $this;
    }
    /**
     * Get Vehicles value
     * @return \ArrayType\ArrayOfIdentifierVehicle|null
     */
    public function getVehicles()
    {
        return $this->Vehicles;
    }
    /**
     * Set Vehicles value
     * @param \ArrayType\ArrayOfIdentifierVehicle $vehicles
     * @return \StructType\PositionSelection_V5
     */
    public function setVehicles(\ArrayType\ArrayOfIdentifierVehicle $vehicles = null)
    {
        $this->Vehicles = $vehicles;
        return $this;
    }
    /**
     * Get Trailers value
     * @return \ArrayType\ArrayOfIdentifierVehicle|null
     */
    public function getTrailers()
    {
        return $this->Trailers;
    }
    /**
     * Set Trailers value
     * @param \ArrayType\ArrayOfIdentifierVehicle $trailers
     * @return \StructType\PositionSelection_V5
     */
    public function setTrailers(\ArrayType\ArrayOfIdentifierVehicle $trailers = null)
    {
        $this->Trailers = $trailers;
        return $this;
    }
    /**
     * Get DateStrategySelection value
     * @return \StructType\DateStrategySelection|null
     */
    public function getDateStrategySelection()
    {
        return $this->DateStrategySelection;
    }
    /**
     * Set DateStrategySelection value
     * @param \StructType\DateStrategySelection $dateStrategySelection
     * @return \StructType\PositionSelection_V5
     */
    public function setDateStrategySelection(\StructType\DateStrategySelection $dateStrategySelection = null)
    {
        $this->DateStrategySelection = $dateStrategySelection;
        return $this;
    }
}
