<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PositionSelection_V3 StructType
 * @subpackage Structs
 */
class PositionSelection_V3 extends PositionSelection_V2
{
    /**
     * The DataSource
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DataSource;
    /**
     * Constructor method for PositionSelection_V3
     * @uses PositionSelection_V3::setDataSource()
     * @param string $dataSource
     */
    public function __construct($dataSource = null)
    {
        $this
            ->setDataSource($dataSource);
    }
    /**
     * Get DataSource value
     * @return string
     */
    public function getDataSource()
    {
        return $this->DataSource;
    }
    /**
     * Set DataSource value
     * @uses \EnumType\PositionDataSource::valueIsValid()
     * @uses \EnumType\PositionDataSource::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dataSource
     * @return \StructType\PositionSelection_V3
     */
    public function setDataSource($dataSource = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PositionDataSource::valueIsValid($dataSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PositionDataSource', is_array($dataSource) ? implode(', ', $dataSource) : var_export($dataSource, true), implode(', ', \EnumType\PositionDataSource::getValidValues())), __LINE__);
        }
        $this->DataSource = $dataSource;
        return $this;
    }
}
