<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PoiItem StructType
 * @subpackage Structs
 */
class PoiItem extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The From
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $From;
    /**
     * The Until
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Until;
    /**
     * Constructor method for PoiItem
     * @uses PoiItem::setId()
     * @uses PoiItem::setFrom()
     * @uses PoiItem::setUntil()
     * @param int $id
     * @param string $from
     * @param string $until
     */
    public function __construct($id = null, $from = null, $until = null)
    {
        $this
            ->setId($id)
            ->setFrom($from)
            ->setUntil($until);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\PoiItem
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get From value
     * @return string
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param string $from
     * @return \StructType\PoiItem
     */
    public function setFrom($from = null)
    {
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from, true), gettype($from)), __LINE__);
        }
        $this->From = $from;
        return $this;
    }
    /**
     * Get Until value
     * @return string
     */
    public function getUntil()
    {
        return $this->Until;
    }
    /**
     * Set Until value
     * @param string $until
     * @return \StructType\PoiItem
     */
    public function setUntil($until = null)
    {
        // validation for constraint: string
        if (!is_null($until) && !is_string($until)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($until, true), gettype($until)), __LINE__);
        }
        $this->Until = $until;
        return $this;
    }
}
