<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlanningHistoricalSelection StructType
 * @subpackage Structs
 */
class PlanningHistoricalSelection extends AbstractStructBase
{
    /**
     * The SelectionType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SelectionType;
    /**
     * The DateTimeSelectionType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateTimeSelectionType;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Identifier
     */
    public $Driver;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicle
     */
    public $Vehicle;
    /**
     * The DateTimeRange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeRangeSelection
     */
    public $DateTimeRange;
    /**
     * Constructor method for PlanningHistoricalSelection
     * @uses PlanningHistoricalSelection::setSelectionType()
     * @uses PlanningHistoricalSelection::setDateTimeSelectionType()
     * @uses PlanningHistoricalSelection::setDriver()
     * @uses PlanningHistoricalSelection::setVehicle()
     * @uses PlanningHistoricalSelection::setDateTimeRange()
     * @param string $selectionType
     * @param string $dateTimeSelectionType
     * @param \StructType\Identifier $driver
     * @param \StructType\IdentifierVehicle $vehicle
     * @param \StructType\DateTimeRangeSelection $dateTimeRange
     */
    public function __construct($selectionType = null, $dateTimeSelectionType = null, \StructType\Identifier $driver = null, \StructType\IdentifierVehicle $vehicle = null, \StructType\DateTimeRangeSelection $dateTimeRange = null)
    {
        $this
            ->setSelectionType($selectionType)
            ->setDateTimeSelectionType($dateTimeSelectionType)
            ->setDriver($driver)
            ->setVehicle($vehicle)
            ->setDateTimeRange($dateTimeRange);
    }
    /**
     * Get SelectionType value
     * @return string
     */
    public function getSelectionType()
    {
        return $this->SelectionType;
    }
    /**
     * Set SelectionType value
     * @uses \EnumType\EnumPlanningSelectionHistoricalType::valueIsValid()
     * @uses \EnumType\EnumPlanningSelectionHistoricalType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $selectionType
     * @return \StructType\PlanningHistoricalSelection
     */
    public function setSelectionType($selectionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumPlanningSelectionHistoricalType::valueIsValid($selectionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumPlanningSelectionHistoricalType', is_array($selectionType) ? implode(', ', $selectionType) : var_export($selectionType, true), implode(', ', \EnumType\EnumPlanningSelectionHistoricalType::getValidValues())), __LINE__);
        }
        $this->SelectionType = $selectionType;
        return $this;
    }
    /**
     * Get DateTimeSelectionType value
     * @return string
     */
    public function getDateTimeSelectionType()
    {
        return $this->DateTimeSelectionType;
    }
    /**
     * Set DateTimeSelectionType value
     * @uses \EnumType\EnumPlanningSelectionDateTime::valueIsValid()
     * @uses \EnumType\EnumPlanningSelectionDateTime::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dateTimeSelectionType
     * @return \StructType\PlanningHistoricalSelection
     */
    public function setDateTimeSelectionType($dateTimeSelectionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumPlanningSelectionDateTime::valueIsValid($dateTimeSelectionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumPlanningSelectionDateTime', is_array($dateTimeSelectionType) ? implode(', ', $dateTimeSelectionType) : var_export($dateTimeSelectionType, true), implode(', ', \EnumType\EnumPlanningSelectionDateTime::getValidValues())), __LINE__);
        }
        $this->DateTimeSelectionType = $dateTimeSelectionType;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\Identifier|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\Identifier $driver
     * @return \StructType\PlanningHistoricalSelection
     */
    public function setDriver(\StructType\Identifier $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicle|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicle $vehicle
     * @return \StructType\PlanningHistoricalSelection
     */
    public function setVehicle(\StructType\IdentifierVehicle $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get DateTimeRange value
     * @return \StructType\DateTimeRangeSelection|null
     */
    public function getDateTimeRange()
    {
        return $this->DateTimeRange;
    }
    /**
     * Set DateTimeRange value
     * @param \StructType\DateTimeRangeSelection $dateTimeRange
     * @return \StructType\PlanningHistoricalSelection
     */
    public function setDateTimeRange(\StructType\DateTimeRangeSelection $dateTimeRange = null)
    {
        $this->DateTimeRange = $dateTimeRange;
        return $this;
    }
}
