<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Place_V2 StructType
 * @subpackage Structs
 */
abstract class Place_V2 extends AbstractStructBase
{
    /**
     * The OrderSequence
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $OrderSequence;
    /**
     * The ExecutionDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExecutionDate;
    /**
     * The AlarmTimeETA
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AlarmTimeETA;
    /**
     * The PlaceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PlaceId;
    /**
     * The DriverDisplay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverDisplay;
    /**
     * The DispatcherDisplay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DispatcherDisplay;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ActivityPlace
     */
    public $Activity;
    /**
     * Constructor method for Place_V2
     * @uses Place_V2::setOrderSequence()
     * @uses Place_V2::setExecutionDate()
     * @uses Place_V2::setAlarmTimeETA()
     * @uses Place_V2::setPlaceId()
     * @uses Place_V2::setDriverDisplay()
     * @uses Place_V2::setDispatcherDisplay()
     * @uses Place_V2::setComment()
     * @uses Place_V2::setActivity()
     * @param int $orderSequence
     * @param string $executionDate
     * @param int $alarmTimeETA
     * @param string $placeId
     * @param string $driverDisplay
     * @param string $dispatcherDisplay
     * @param string $comment
     * @param \StructType\ActivityPlace $activity
     */
    public function __construct($orderSequence = null, $executionDate = null, $alarmTimeETA = null, $placeId = null, $driverDisplay = null, $dispatcherDisplay = null, $comment = null, \StructType\ActivityPlace $activity = null)
    {
        $this
            ->setOrderSequence($orderSequence)
            ->setExecutionDate($executionDate)
            ->setAlarmTimeETA($alarmTimeETA)
            ->setPlaceId($placeId)
            ->setDriverDisplay($driverDisplay)
            ->setDispatcherDisplay($dispatcherDisplay)
            ->setComment($comment)
            ->setActivity($activity);
    }
    /**
     * Get OrderSequence value
     * @return int
     */
    public function getOrderSequence()
    {
        return $this->OrderSequence;
    }
    /**
     * Set OrderSequence value
     * @param int $orderSequence
     * @return \StructType\Place_V2
     */
    public function setOrderSequence($orderSequence = null)
    {
        // validation for constraint: int
        if (!is_null($orderSequence) && !(is_int($orderSequence) || ctype_digit($orderSequence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderSequence, true), gettype($orderSequence)), __LINE__);
        }
        $this->OrderSequence = $orderSequence;
        return $this;
    }
    /**
     * Get ExecutionDate value
     * @return string
     */
    public function getExecutionDate()
    {
        return $this->ExecutionDate;
    }
    /**
     * Set ExecutionDate value
     * @param string $executionDate
     * @return \StructType\Place_V2
     */
    public function setExecutionDate($executionDate = null)
    {
        // validation for constraint: string
        if (!is_null($executionDate) && !is_string($executionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($executionDate, true), gettype($executionDate)), __LINE__);
        }
        $this->ExecutionDate = $executionDate;
        return $this;
    }
    /**
     * Get AlarmTimeETA value
     * @return int
     */
    public function getAlarmTimeETA()
    {
        return $this->AlarmTimeETA;
    }
    /**
     * Set AlarmTimeETA value
     * @param int $alarmTimeETA
     * @return \StructType\Place_V2
     */
    public function setAlarmTimeETA($alarmTimeETA = null)
    {
        // validation for constraint: int
        if (!is_null($alarmTimeETA) && !(is_int($alarmTimeETA) || ctype_digit($alarmTimeETA))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alarmTimeETA, true), gettype($alarmTimeETA)), __LINE__);
        }
        $this->AlarmTimeETA = $alarmTimeETA;
        return $this;
    }
    /**
     * Get PlaceId value
     * @return string|null
     */
    public function getPlaceId()
    {
        return $this->PlaceId;
    }
    /**
     * Set PlaceId value
     * @param string $placeId
     * @return \StructType\Place_V2
     */
    public function setPlaceId($placeId = null)
    {
        // validation for constraint: string
        if (!is_null($placeId) && !is_string($placeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($placeId, true), gettype($placeId)), __LINE__);
        }
        $this->PlaceId = $placeId;
        return $this;
    }
    /**
     * Get DriverDisplay value
     * @return string|null
     */
    public function getDriverDisplay()
    {
        return $this->DriverDisplay;
    }
    /**
     * Set DriverDisplay value
     * @param string $driverDisplay
     * @return \StructType\Place_V2
     */
    public function setDriverDisplay($driverDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($driverDisplay) && !is_string($driverDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverDisplay, true), gettype($driverDisplay)), __LINE__);
        }
        $this->DriverDisplay = $driverDisplay;
        return $this;
    }
    /**
     * Get DispatcherDisplay value
     * @return string|null
     */
    public function getDispatcherDisplay()
    {
        return $this->DispatcherDisplay;
    }
    /**
     * Set DispatcherDisplay value
     * @param string $dispatcherDisplay
     * @return \StructType\Place_V2
     */
    public function setDispatcherDisplay($dispatcherDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($dispatcherDisplay) && !is_string($dispatcherDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dispatcherDisplay, true), gettype($dispatcherDisplay)), __LINE__);
        }
        $this->DispatcherDisplay = $dispatcherDisplay;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Place_V2
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\ActivityPlace|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\ActivityPlace $activity
     * @return \StructType\Place_V2
     */
    public function setActivity(\StructType\ActivityPlace $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
}
