<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlaceItemResult_V5 StructType
 * @subpackage Structs
 */
class PlaceItemResult_V5 extends Place
{
    /**
     * The ModificationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ModificationDate;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The TransferStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TransferStatus;
    /**
     * The ExternalSynchStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExternalSynchStatus;
    /**
     * The CancelStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CancelStatus;
    /**
     * The TransicsPlaceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransicsPlaceID;
    /**
     * The PlaceStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PlaceStatus;
    /**
     * The SalesPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $SalesPrice;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $Driver;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult_V2
     */
    public $Vehicle;
    /**
     * The Author
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Author;
    /**
     * The Products
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfProductIdentifier
     */
    public $Products;
    /**
     * The Jobs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJobIdentifier
     */
    public $Jobs;
    /**
     * The Documents
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDocument
     */
    public $Documents;
    /**
     * The TachoActivities
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTachoActivity
     */
    public $TachoActivities;
    /**
     * The PlaceCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PlaceCode;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * The ViaRoute
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ViaRouteItemResult
     */
    public $ViaRoute;
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustomerResult_V2
     */
    public $Customer;
    /**
     * The Shipper
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ShipperResult_V2
     */
    public $Shipper;
    /**
     * The CoDriver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $CoDriver;
    /**
     * The AddressDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressDescription;
    /**
     * Constructor method for PlaceItemResult_V5
     * @uses PlaceItemResult_V5::setModificationDate()
     * @uses PlaceItemResult_V5::setStartDate()
     * @uses PlaceItemResult_V5::setEndDate()
     * @uses PlaceItemResult_V5::setStatus()
     * @uses PlaceItemResult_V5::setTransferStatus()
     * @uses PlaceItemResult_V5::setExternalSynchStatus()
     * @uses PlaceItemResult_V5::setCancelStatus()
     * @uses PlaceItemResult_V5::setTransicsPlaceID()
     * @uses PlaceItemResult_V5::setPlaceStatus()
     * @uses PlaceItemResult_V5::setSalesPrice()
     * @uses PlaceItemResult_V5::setDriver()
     * @uses PlaceItemResult_V5::setVehicle()
     * @uses PlaceItemResult_V5::setAuthor()
     * @uses PlaceItemResult_V5::setProducts()
     * @uses PlaceItemResult_V5::setJobs()
     * @uses PlaceItemResult_V5::setDocuments()
     * @uses PlaceItemResult_V5::setTachoActivities()
     * @uses PlaceItemResult_V5::setPlaceCode()
     * @uses PlaceItemResult_V5::setPosition()
     * @uses PlaceItemResult_V5::setViaRoute()
     * @uses PlaceItemResult_V5::setCustomer()
     * @uses PlaceItemResult_V5::setShipper()
     * @uses PlaceItemResult_V5::setCoDriver()
     * @uses PlaceItemResult_V5::setAddressDescription()
     * @param string $modificationDate
     * @param string $startDate
     * @param string $endDate
     * @param string $status
     * @param string $transferStatus
     * @param string $externalSynchStatus
     * @param string $cancelStatus
     * @param int $transicsPlaceID
     * @param string $placeStatus
     * @param float $salesPrice
     * @param \StructType\IdentifierPerson_V2 $driver
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @param string $author
     * @param \ArrayType\ArrayOfProductIdentifier $products
     * @param \ArrayType\ArrayOfJobIdentifier $jobs
     * @param \ArrayType\ArrayOfDocument $documents
     * @param \ArrayType\ArrayOfTachoActivity $tachoActivities
     * @param string $placeCode
     * @param \StructType\Position $position
     * @param \StructType\ViaRouteItemResult $viaRoute
     * @param \StructType\CustomerResult_V2 $customer
     * @param \StructType\ShipperResult_V2 $shipper
     * @param \StructType\IdentifierPerson_V2 $coDriver
     * @param string $addressDescription
     */
    public function __construct($modificationDate = null, $startDate = null, $endDate = null, $status = null, $transferStatus = null, $externalSynchStatus = null, $cancelStatus = null, $transicsPlaceID = null, $placeStatus = null, $salesPrice = null, \StructType\IdentifierPerson_V2 $driver = null, \StructType\IdentifierVehicleResult_V2 $vehicle = null, $author = null, \ArrayType\ArrayOfProductIdentifier $products = null, \ArrayType\ArrayOfJobIdentifier $jobs = null, \ArrayType\ArrayOfDocument $documents = null, \ArrayType\ArrayOfTachoActivity $tachoActivities = null, $placeCode = null, \StructType\Position $position = null, \StructType\ViaRouteItemResult $viaRoute = null, \StructType\CustomerResult_V2 $customer = null, \StructType\ShipperResult_V2 $shipper = null, \StructType\IdentifierPerson_V2 $coDriver = null, $addressDescription = null)
    {
        $this
            ->setModificationDate($modificationDate)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setStatus($status)
            ->setTransferStatus($transferStatus)
            ->setExternalSynchStatus($externalSynchStatus)
            ->setCancelStatus($cancelStatus)
            ->setTransicsPlaceID($transicsPlaceID)
            ->setPlaceStatus($placeStatus)
            ->setSalesPrice($salesPrice)
            ->setDriver($driver)
            ->setVehicle($vehicle)
            ->setAuthor($author)
            ->setProducts($products)
            ->setJobs($jobs)
            ->setDocuments($documents)
            ->setTachoActivities($tachoActivities)
            ->setPlaceCode($placeCode)
            ->setPosition($position)
            ->setViaRoute($viaRoute)
            ->setCustomer($customer)
            ->setShipper($shipper)
            ->setCoDriver($coDriver)
            ->setAddressDescription($addressDescription);
    }
    /**
     * Get ModificationDate value
     * @return string
     */
    public function getModificationDate()
    {
        return $this->ModificationDate;
    }
    /**
     * Set ModificationDate value
     * @param string $modificationDate
     * @return \StructType\PlaceItemResult_V5
     */
    public function setModificationDate($modificationDate = null)
    {
        // validation for constraint: string
        if (!is_null($modificationDate) && !is_string($modificationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modificationDate, true), gettype($modificationDate)), __LINE__);
        }
        $this->ModificationDate = $modificationDate;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\PlaceItemResult_V5
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\PlaceItemResult_V5
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\EnumPlanningStatus::valueIsValid()
     * @uses \EnumType\EnumPlanningStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\PlaceItemResult_V5
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumPlanningStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumPlanningStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\EnumPlanningStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get TransferStatus value
     * @return string
     */
    public function getTransferStatus()
    {
        return $this->TransferStatus;
    }
    /**
     * Set TransferStatus value
     * @uses \EnumType\EnumTransferStatus::valueIsValid()
     * @uses \EnumType\EnumTransferStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transferStatus
     * @return \StructType\PlaceItemResult_V5
     */
    public function setTransferStatus($transferStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTransferStatus::valueIsValid($transferStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumTransferStatus', is_array($transferStatus) ? implode(', ', $transferStatus) : var_export($transferStatus, true), implode(', ', \EnumType\EnumTransferStatus::getValidValues())), __LINE__);
        }
        $this->TransferStatus = $transferStatus;
        return $this;
    }
    /**
     * Get ExternalSynchStatus value
     * @return string
     */
    public function getExternalSynchStatus()
    {
        return $this->ExternalSynchStatus;
    }
    /**
     * Set ExternalSynchStatus value
     * @uses \EnumType\EnumSynchronisationStatus::valueIsValid()
     * @uses \EnumType\EnumSynchronisationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $externalSynchStatus
     * @return \StructType\PlaceItemResult_V5
     */
    public function setExternalSynchStatus($externalSynchStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumSynchronisationStatus::valueIsValid($externalSynchStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumSynchronisationStatus', is_array($externalSynchStatus) ? implode(', ', $externalSynchStatus) : var_export($externalSynchStatus, true), implode(', ', \EnumType\EnumSynchronisationStatus::getValidValues())), __LINE__);
        }
        $this->ExternalSynchStatus = $externalSynchStatus;
        return $this;
    }
    /**
     * Get CancelStatus value
     * @return string
     */
    public function getCancelStatus()
    {
        return $this->CancelStatus;
    }
    /**
     * Set CancelStatus value
     * @uses \EnumType\EnumCancelStatus::valueIsValid()
     * @uses \EnumType\EnumCancelStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cancelStatus
     * @return \StructType\PlaceItemResult_V5
     */
    public function setCancelStatus($cancelStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumCancelStatus::valueIsValid($cancelStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumCancelStatus', is_array($cancelStatus) ? implode(', ', $cancelStatus) : var_export($cancelStatus, true), implode(', ', \EnumType\EnumCancelStatus::getValidValues())), __LINE__);
        }
        $this->CancelStatus = $cancelStatus;
        return $this;
    }
    /**
     * Get TransicsPlaceID value
     * @return int
     */
    public function getTransicsPlaceID()
    {
        return $this->TransicsPlaceID;
    }
    /**
     * Set TransicsPlaceID value
     * @param int $transicsPlaceID
     * @return \StructType\PlaceItemResult_V5
     */
    public function setTransicsPlaceID($transicsPlaceID = null)
    {
        // validation for constraint: int
        if (!is_null($transicsPlaceID) && !(is_int($transicsPlaceID) || ctype_digit($transicsPlaceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transicsPlaceID, true), gettype($transicsPlaceID)), __LINE__);
        }
        $this->TransicsPlaceID = $transicsPlaceID;
        return $this;
    }
    /**
     * Get PlaceStatus value
     * @return string
     */
    public function getPlaceStatus()
    {
        return $this->PlaceStatus;
    }
    /**
     * Set PlaceStatus value
     * @uses \EnumType\EnumPlaceStatus::valueIsValid()
     * @uses \EnumType\EnumPlaceStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $placeStatus
     * @return \StructType\PlaceItemResult_V5
     */
    public function setPlaceStatus($placeStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumPlaceStatus::valueIsValid($placeStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumPlaceStatus', is_array($placeStatus) ? implode(', ', $placeStatus) : var_export($placeStatus, true), implode(', ', \EnumType\EnumPlaceStatus::getValidValues())), __LINE__);
        }
        $this->PlaceStatus = $placeStatus;
        return $this;
    }
    /**
     * Get SalesPrice value
     * @return float
     */
    public function getSalesPrice()
    {
        return $this->SalesPrice;
    }
    /**
     * Set SalesPrice value
     * @param float $salesPrice
     * @return \StructType\PlaceItemResult_V5
     */
    public function setSalesPrice($salesPrice = null)
    {
        // validation for constraint: float
        if (!is_null($salesPrice) && !(is_float($salesPrice) || is_numeric($salesPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($salesPrice, true), gettype($salesPrice)), __LINE__);
        }
        $this->SalesPrice = $salesPrice;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson_V2 $driver
     * @return \StructType\PlaceItemResult_V5
     */
    public function setDriver(\StructType\IdentifierPerson_V2 $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult_V2|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @return \StructType\PlaceItemResult_V5
     */
    public function setVehicle(\StructType\IdentifierVehicleResult_V2 $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Author value
     * @return string|null
     */
    public function getAuthor()
    {
        return $this->Author;
    }
    /**
     * Set Author value
     * @param string $author
     * @return \StructType\PlaceItemResult_V5
     */
    public function setAuthor($author = null)
    {
        // validation for constraint: string
        if (!is_null($author) && !is_string($author)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($author, true), gettype($author)), __LINE__);
        }
        $this->Author = $author;
        return $this;
    }
    /**
     * Get Products value
     * @return \ArrayType\ArrayOfProductIdentifier|null
     */
    public function getProducts()
    {
        return $this->Products;
    }
    /**
     * Set Products value
     * @param \ArrayType\ArrayOfProductIdentifier $products
     * @return \StructType\PlaceItemResult_V5
     */
    public function setProducts(\ArrayType\ArrayOfProductIdentifier $products = null)
    {
        $this->Products = $products;
        return $this;
    }
    /**
     * Get Jobs value
     * @return \ArrayType\ArrayOfJobIdentifier|null
     */
    public function getJobs()
    {
        return $this->Jobs;
    }
    /**
     * Set Jobs value
     * @param \ArrayType\ArrayOfJobIdentifier $jobs
     * @return \StructType\PlaceItemResult_V5
     */
    public function setJobs(\ArrayType\ArrayOfJobIdentifier $jobs = null)
    {
        $this->Jobs = $jobs;
        return $this;
    }
    /**
     * Get Documents value
     * @return \ArrayType\ArrayOfDocument|null
     */
    public function getDocuments()
    {
        return $this->Documents;
    }
    /**
     * Set Documents value
     * @param \ArrayType\ArrayOfDocument $documents
     * @return \StructType\PlaceItemResult_V5
     */
    public function setDocuments(\ArrayType\ArrayOfDocument $documents = null)
    {
        $this->Documents = $documents;
        return $this;
    }
    /**
     * Get TachoActivities value
     * @return \ArrayType\ArrayOfTachoActivity|null
     */
    public function getTachoActivities()
    {
        return $this->TachoActivities;
    }
    /**
     * Set TachoActivities value
     * @param \ArrayType\ArrayOfTachoActivity $tachoActivities
     * @return \StructType\PlaceItemResult_V5
     */
    public function setTachoActivities(\ArrayType\ArrayOfTachoActivity $tachoActivities = null)
    {
        $this->TachoActivities = $tachoActivities;
        return $this;
    }
    /**
     * Get PlaceCode value
     * @return string|null
     */
    public function getPlaceCode()
    {
        return $this->PlaceCode;
    }
    /**
     * Set PlaceCode value
     * @param string $placeCode
     * @return \StructType\PlaceItemResult_V5
     */
    public function setPlaceCode($placeCode = null)
    {
        // validation for constraint: string
        if (!is_null($placeCode) && !is_string($placeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($placeCode, true), gettype($placeCode)), __LINE__);
        }
        $this->PlaceCode = $placeCode;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\PlaceItemResult_V5
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get ViaRoute value
     * @return \StructType\ViaRouteItemResult|null
     */
    public function getViaRoute()
    {
        return $this->ViaRoute;
    }
    /**
     * Set ViaRoute value
     * @param \StructType\ViaRouteItemResult $viaRoute
     * @return \StructType\PlaceItemResult_V5
     */
    public function setViaRoute(\StructType\ViaRouteItemResult $viaRoute = null)
    {
        $this->ViaRoute = $viaRoute;
        return $this;
    }
    /**
     * Get Customer value
     * @return \StructType\CustomerResult_V2|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\CustomerResult_V2 $customer
     * @return \StructType\PlaceItemResult_V5
     */
    public function setCustomer(\StructType\CustomerResult_V2 $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get Shipper value
     * @return \StructType\ShipperResult_V2|null
     */
    public function getShipper()
    {
        return $this->Shipper;
    }
    /**
     * Set Shipper value
     * @param \StructType\ShipperResult_V2 $shipper
     * @return \StructType\PlaceItemResult_V5
     */
    public function setShipper(\StructType\ShipperResult_V2 $shipper = null)
    {
        $this->Shipper = $shipper;
        return $this;
    }
    /**
     * Get CoDriver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getCoDriver()
    {
        return $this->CoDriver;
    }
    /**
     * Set CoDriver value
     * @param \StructType\IdentifierPerson_V2 $coDriver
     * @return \StructType\PlaceItemResult_V5
     */
    public function setCoDriver(\StructType\IdentifierPerson_V2 $coDriver = null)
    {
        $this->CoDriver = $coDriver;
        return $this;
    }
    /**
     * Get AddressDescription value
     * @return string|null
     */
    public function getAddressDescription()
    {
        return $this->AddressDescription;
    }
    /**
     * Set AddressDescription value
     * @param string $addressDescription
     * @return \StructType\PlaceItemResult_V5
     */
    public function setAddressDescription($addressDescription = null)
    {
        // validation for constraint: string
        if (!is_null($addressDescription) && !is_string($addressDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressDescription, true), gettype($addressDescription)), __LINE__);
        }
        $this->AddressDescription = $addressDescription;
        return $this;
    }
}
