<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonLabourContract_V2 StructType
 * @subpackage Structs
 */
class PersonLabourContract_V2 extends AbstractStructBase
{
    /**
     * The Contract
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Contract;
    /**
     * The ManagementOfActivityRangesIsActive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ManagementOfActivityRangesIsActive;
    /**
     * The ManagementOfActivityPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ManagementOfActivityPeriod
     */
    public $ManagementOfActivityPeriod;
    /**
     * Constructor method for PersonLabourContract_V2
     * @uses PersonLabourContract_V2::setContract()
     * @uses PersonLabourContract_V2::setManagementOfActivityRangesIsActive()
     * @uses PersonLabourContract_V2::setManagementOfActivityPeriod()
     * @param string $contract
     * @param bool $managementOfActivityRangesIsActive
     * @param \StructType\ManagementOfActivityPeriod $managementOfActivityPeriod
     */
    public function __construct($contract = null, $managementOfActivityRangesIsActive = null, \StructType\ManagementOfActivityPeriod $managementOfActivityPeriod = null)
    {
        $this
            ->setContract($contract)
            ->setManagementOfActivityRangesIsActive($managementOfActivityRangesIsActive)
            ->setManagementOfActivityPeriod($managementOfActivityPeriod);
    }
    /**
     * Get Contract value
     * @return string
     */
    public function getContract()
    {
        return $this->Contract;
    }
    /**
     * Set Contract value
     * @uses \EnumType\EnumContractType::valueIsValid()
     * @uses \EnumType\EnumContractType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $contract
     * @return \StructType\PersonLabourContract_V2
     */
    public function setContract($contract = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumContractType::valueIsValid($contract)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumContractType', is_array($contract) ? implode(', ', $contract) : var_export($contract, true), implode(', ', \EnumType\EnumContractType::getValidValues())), __LINE__);
        }
        $this->Contract = $contract;
        return $this;
    }
    /**
     * Get ManagementOfActivityRangesIsActive value
     * @return bool
     */
    public function getManagementOfActivityRangesIsActive()
    {
        return $this->ManagementOfActivityRangesIsActive;
    }
    /**
     * Set ManagementOfActivityRangesIsActive value
     * @param bool $managementOfActivityRangesIsActive
     * @return \StructType\PersonLabourContract_V2
     */
    public function setManagementOfActivityRangesIsActive($managementOfActivityRangesIsActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($managementOfActivityRangesIsActive) && !is_bool($managementOfActivityRangesIsActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($managementOfActivityRangesIsActive, true), gettype($managementOfActivityRangesIsActive)), __LINE__);
        }
        $this->ManagementOfActivityRangesIsActive = $managementOfActivityRangesIsActive;
        return $this;
    }
    /**
     * Get ManagementOfActivityPeriod value
     * @return \StructType\ManagementOfActivityPeriod|null
     */
    public function getManagementOfActivityPeriod()
    {
        return $this->ManagementOfActivityPeriod;
    }
    /**
     * Set ManagementOfActivityPeriod value
     * @param \StructType\ManagementOfActivityPeriod $managementOfActivityPeriod
     * @return \StructType\PersonLabourContract_V2
     */
    public function setManagementOfActivityPeriod(\StructType\ManagementOfActivityPeriod $managementOfActivityPeriod = null)
    {
        $this->ManagementOfActivityPeriod = $managementOfActivityPeriod;
        return $this;
    }
}
