<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonLabourContract StructType
 * @subpackage Structs
 */
class PersonLabourContract extends AbstractStructBase
{
    /**
     * The Contract
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Contract;
    /**
     * The ManagementOfActivityRangesIsActive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ManagementOfActivityRangesIsActive;
    /**
     * The ManagementOfActivityPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfManagementOfActivityPeriod
     */
    public $ManagementOfActivityPeriod;
    /**
     * Constructor method for PersonLabourContract
     * @uses PersonLabourContract::setContract()
     * @uses PersonLabourContract::setManagementOfActivityRangesIsActive()
     * @uses PersonLabourContract::setManagementOfActivityPeriod()
     * @param string $contract
     * @param bool $managementOfActivityRangesIsActive
     * @param \ArrayType\ArrayOfManagementOfActivityPeriod $managementOfActivityPeriod
     */
    public function __construct($contract = null, $managementOfActivityRangesIsActive = null, \ArrayType\ArrayOfManagementOfActivityPeriod $managementOfActivityPeriod = null)
    {
        $this
            ->setContract($contract)
            ->setManagementOfActivityRangesIsActive($managementOfActivityRangesIsActive)
            ->setManagementOfActivityPeriod($managementOfActivityPeriod);
    }
    /**
     * Get Contract value
     * @return string
     */
    public function getContract()
    {
        return $this->Contract;
    }
    /**
     * Set Contract value
     * @uses \EnumType\EnumContractType::valueIsValid()
     * @uses \EnumType\EnumContractType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $contract
     * @return \StructType\PersonLabourContract
     */
    public function setContract($contract = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumContractType::valueIsValid($contract)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumContractType', is_array($contract) ? implode(', ', $contract) : var_export($contract, true), implode(', ', \EnumType\EnumContractType::getValidValues())), __LINE__);
        }
        $this->Contract = $contract;
        return $this;
    }
    /**
     * Get ManagementOfActivityRangesIsActive value
     * @return bool
     */
    public function getManagementOfActivityRangesIsActive()
    {
        return $this->ManagementOfActivityRangesIsActive;
    }
    /**
     * Set ManagementOfActivityRangesIsActive value
     * @param bool $managementOfActivityRangesIsActive
     * @return \StructType\PersonLabourContract
     */
    public function setManagementOfActivityRangesIsActive($managementOfActivityRangesIsActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($managementOfActivityRangesIsActive) && !is_bool($managementOfActivityRangesIsActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($managementOfActivityRangesIsActive, true), gettype($managementOfActivityRangesIsActive)), __LINE__);
        }
        $this->ManagementOfActivityRangesIsActive = $managementOfActivityRangesIsActive;
        return $this;
    }
    /**
     * Get ManagementOfActivityPeriod value
     * @return \ArrayType\ArrayOfManagementOfActivityPeriod|null
     */
    public function getManagementOfActivityPeriod()
    {
        return $this->ManagementOfActivityPeriod;
    }
    /**
     * Set ManagementOfActivityPeriod value
     * @param \ArrayType\ArrayOfManagementOfActivityPeriod $managementOfActivityPeriod
     * @return \StructType\PersonLabourContract
     */
    public function setManagementOfActivityPeriod(\ArrayType\ArrayOfManagementOfActivityPeriod $managementOfActivityPeriod = null)
    {
        $this->ManagementOfActivityPeriod = $managementOfActivityPeriod;
        return $this;
    }
}
