<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonHRInfo_V2 StructType
 * @subpackage Structs
 */
class PersonHRInfo_V2 extends AbstractStructBase
{
    /**
     * The Employed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Employed;
    /**
     * The Resigned
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Resigned;
    /**
     * The Birthday
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Birthday;
    /**
     * The BirthCity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BirthCity;
    /**
     * The Rating
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Rating;
    /**
     * The HoursPerMonth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HoursPerMonth;
    /**
     * The HourlyRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HourlyRate;
    /**
     * Constructor method for PersonHRInfo_V2
     * @uses PersonHRInfo_V2::setEmployed()
     * @uses PersonHRInfo_V2::setResigned()
     * @uses PersonHRInfo_V2::setBirthday()
     * @uses PersonHRInfo_V2::setBirthCity()
     * @uses PersonHRInfo_V2::setRating()
     * @uses PersonHRInfo_V2::setHoursPerMonth()
     * @uses PersonHRInfo_V2::setHourlyRate()
     * @param string $employed
     * @param string $resigned
     * @param string $birthday
     * @param string $birthCity
     * @param string $rating
     * @param string $hoursPerMonth
     * @param string $hourlyRate
     */
    public function __construct($employed = null, $resigned = null, $birthday = null, $birthCity = null, $rating = null, $hoursPerMonth = null, $hourlyRate = null)
    {
        $this
            ->setEmployed($employed)
            ->setResigned($resigned)
            ->setBirthday($birthday)
            ->setBirthCity($birthCity)
            ->setRating($rating)
            ->setHoursPerMonth($hoursPerMonth)
            ->setHourlyRate($hourlyRate);
    }
    /**
     * Get Employed value
     * @return string
     */
    public function getEmployed()
    {
        return $this->Employed;
    }
    /**
     * Set Employed value
     * @param string $employed
     * @return \StructType\PersonHRInfo_V2
     */
    public function setEmployed($employed = null)
    {
        // validation for constraint: string
        if (!is_null($employed) && !is_string($employed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($employed, true), gettype($employed)), __LINE__);
        }
        $this->Employed = $employed;
        return $this;
    }
    /**
     * Get Resigned value
     * @return string
     */
    public function getResigned()
    {
        return $this->Resigned;
    }
    /**
     * Set Resigned value
     * @param string $resigned
     * @return \StructType\PersonHRInfo_V2
     */
    public function setResigned($resigned = null)
    {
        // validation for constraint: string
        if (!is_null($resigned) && !is_string($resigned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resigned, true), gettype($resigned)), __LINE__);
        }
        $this->Resigned = $resigned;
        return $this;
    }
    /**
     * Get Birthday value
     * @return string
     */
    public function getBirthday()
    {
        return $this->Birthday;
    }
    /**
     * Set Birthday value
     * @param string $birthday
     * @return \StructType\PersonHRInfo_V2
     */
    public function setBirthday($birthday = null)
    {
        // validation for constraint: string
        if (!is_null($birthday) && !is_string($birthday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthday, true), gettype($birthday)), __LINE__);
        }
        $this->Birthday = $birthday;
        return $this;
    }
    /**
     * Get BirthCity value
     * @return string|null
     */
    public function getBirthCity()
    {
        return $this->BirthCity;
    }
    /**
     * Set BirthCity value
     * @param string $birthCity
     * @return \StructType\PersonHRInfo_V2
     */
    public function setBirthCity($birthCity = null)
    {
        // validation for constraint: string
        if (!is_null($birthCity) && !is_string($birthCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthCity, true), gettype($birthCity)), __LINE__);
        }
        $this->BirthCity = $birthCity;
        return $this;
    }
    /**
     * Get Rating value
     * @return string|null
     */
    public function getRating()
    {
        return $this->Rating;
    }
    /**
     * Set Rating value
     * @param string $rating
     * @return \StructType\PersonHRInfo_V2
     */
    public function setRating($rating = null)
    {
        // validation for constraint: string
        if (!is_null($rating) && !is_string($rating)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rating, true), gettype($rating)), __LINE__);
        }
        $this->Rating = $rating;
        return $this;
    }
    /**
     * Get HoursPerMonth value
     * @return string|null
     */
    public function getHoursPerMonth()
    {
        return $this->HoursPerMonth;
    }
    /**
     * Set HoursPerMonth value
     * @param string $hoursPerMonth
     * @return \StructType\PersonHRInfo_V2
     */
    public function setHoursPerMonth($hoursPerMonth = null)
    {
        // validation for constraint: string
        if (!is_null($hoursPerMonth) && !is_string($hoursPerMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hoursPerMonth, true), gettype($hoursPerMonth)), __LINE__);
        }
        $this->HoursPerMonth = $hoursPerMonth;
        return $this;
    }
    /**
     * Get HourlyRate value
     * @return string|null
     */
    public function getHourlyRate()
    {
        return $this->HourlyRate;
    }
    /**
     * Set HourlyRate value
     * @param string $hourlyRate
     * @return \StructType\PersonHRInfo_V2
     */
    public function setHourlyRate($hourlyRate = null)
    {
        // validation for constraint: string
        if (!is_null($hourlyRate) && !is_string($hourlyRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hourlyRate, true), gettype($hourlyRate)), __LINE__);
        }
        $this->HourlyRate = $hourlyRate;
        return $this;
    }
}
