<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OBC_Activity StructType
 * @subpackage Structs
 */
class OBC_Activity extends Activity
{
    /**
     * The Started
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Started;
    /**
     * The ActivityCompleted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ActivityCompleted;
    /**
     * The WorkingCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CodeInfo
     */
    public $WorkingCode;
    /**
     * Constructor method for OBC_Activity
     * @uses OBC_Activity::setStarted()
     * @uses OBC_Activity::setActivityCompleted()
     * @uses OBC_Activity::setWorkingCode()
     * @param string $started
     * @param bool $activityCompleted
     * @param \StructType\CodeInfo $workingCode
     */
    public function __construct($started = null, $activityCompleted = null, \StructType\CodeInfo $workingCode = null)
    {
        $this
            ->setStarted($started)
            ->setActivityCompleted($activityCompleted)
            ->setWorkingCode($workingCode);
    }
    /**
     * Get Started value
     * @return string
     */
    public function getStarted()
    {
        return $this->Started;
    }
    /**
     * Set Started value
     * @param string $started
     * @return \StructType\OBC_Activity
     */
    public function setStarted($started = null)
    {
        // validation for constraint: string
        if (!is_null($started) && !is_string($started)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($started, true), gettype($started)), __LINE__);
        }
        $this->Started = $started;
        return $this;
    }
    /**
     * Get ActivityCompleted value
     * @return bool
     */
    public function getActivityCompleted()
    {
        return $this->ActivityCompleted;
    }
    /**
     * Set ActivityCompleted value
     * @param bool $activityCompleted
     * @return \StructType\OBC_Activity
     */
    public function setActivityCompleted($activityCompleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($activityCompleted) && !is_bool($activityCompleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($activityCompleted, true), gettype($activityCompleted)), __LINE__);
        }
        $this->ActivityCompleted = $activityCompleted;
        return $this;
    }
    /**
     * Get WorkingCode value
     * @return \StructType\CodeInfo|null
     */
    public function getWorkingCode()
    {
        return $this->WorkingCode;
    }
    /**
     * Set WorkingCode value
     * @param \StructType\CodeInfo $workingCode
     * @return \StructType\OBC_Activity
     */
    public function setWorkingCode(\StructType\CodeInfo $workingCode = null)
    {
        $this->WorkingCode = $workingCode;
        return $this;
    }
}
