<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Message StructType
 * @subpackage Structs
 */
class Message extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The MessageJson
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MessageJson;
    /**
     * The Response
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Response;
    /**
     * Constructor method for Message
     * @uses Message::setStatus()
     * @uses Message::setMessageJson()
     * @uses Message::setResponse()
     * @param string $status
     * @param string $messageJson
     * @param string $response
     */
    public function __construct($status = null, $messageJson = null, $response = null)
    {
        $this
            ->setStatus($status)
            ->setMessageJson($messageJson)
            ->setResponse($response);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\Status::valueIsValid()
     * @uses \EnumType\Status::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\Message
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Status::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Status', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\Status::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get MessageJson value
     * @return string|null
     */
    public function getMessageJson()
    {
        return $this->MessageJson;
    }
    /**
     * Set MessageJson value
     * @param string $messageJson
     * @return \StructType\Message
     */
    public function setMessageJson($messageJson = null)
    {
        // validation for constraint: string
        if (!is_null($messageJson) && !is_string($messageJson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageJson, true), gettype($messageJson)), __LINE__);
        }
        $this->MessageJson = $messageJson;
        return $this;
    }
    /**
     * Get Response value
     * @return string|null
     */
    public function getResponse()
    {
        return $this->Response;
    }
    /**
     * Set Response value
     * @param string $response
     * @return \StructType\Message
     */
    public function setResponse($response = null)
    {
        // validation for constraint: string
        if (!is_null($response) && !is_string($response)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($response, true), gettype($response)), __LINE__);
        }
        $this->Response = $response;
        return $this;
    }
}
