<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MapPosition_V2 StructType
 * @subpackage Structs
 */
class MapPosition_V2 extends Position
{
    /**
     * The PixelX
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PixelX;
    /**
     * The PixelY
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PixelY;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Date;
    /**
     * The MapItems
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfMapItem_V2
     */
    public $MapItems;
    /**
     * Constructor method for MapPosition_V2
     * @uses MapPosition_V2::setPixelX()
     * @uses MapPosition_V2::setPixelY()
     * @uses MapPosition_V2::setDate()
     * @uses MapPosition_V2::setMapItems()
     * @param int $pixelX
     * @param int $pixelY
     * @param string $date
     * @param \ArrayType\ArrayOfMapItem_V2 $mapItems
     */
    public function __construct($pixelX = null, $pixelY = null, $date = null, \ArrayType\ArrayOfMapItem_V2 $mapItems = null)
    {
        $this
            ->setPixelX($pixelX)
            ->setPixelY($pixelY)
            ->setDate($date)
            ->setMapItems($mapItems);
    }
    /**
     * Get PixelX value
     * @return int
     */
    public function getPixelX()
    {
        return $this->PixelX;
    }
    /**
     * Set PixelX value
     * @param int $pixelX
     * @return \StructType\MapPosition_V2
     */
    public function setPixelX($pixelX = null)
    {
        // validation for constraint: int
        if (!is_null($pixelX) && !(is_int($pixelX) || ctype_digit($pixelX))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pixelX, true), gettype($pixelX)), __LINE__);
        }
        $this->PixelX = $pixelX;
        return $this;
    }
    /**
     * Get PixelY value
     * @return int
     */
    public function getPixelY()
    {
        return $this->PixelY;
    }
    /**
     * Set PixelY value
     * @param int $pixelY
     * @return \StructType\MapPosition_V2
     */
    public function setPixelY($pixelY = null)
    {
        // validation for constraint: int
        if (!is_null($pixelY) && !(is_int($pixelY) || ctype_digit($pixelY))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pixelY, true), gettype($pixelY)), __LINE__);
        }
        $this->PixelY = $pixelY;
        return $this;
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\MapPosition_V2
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get MapItems value
     * @return \ArrayType\ArrayOfMapItem_V2|null
     */
    public function getMapItems()
    {
        return $this->MapItems;
    }
    /**
     * Set MapItems value
     * @param \ArrayType\ArrayOfMapItem_V2 $mapItems
     * @return \StructType\MapPosition_V2
     */
    public function setMapItems(\ArrayType\ArrayOfMapItem_V2 $mapItems = null)
    {
        $this->MapItems = $mapItems;
        return $this;
    }
}
