<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MagellanTracerPositionInfo_V2 StructType
 * @subpackage Structs
 */
class MagellanTracerPositionInfo_V2 extends AbstractStructBase
{
    /**
     * The Direction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Direction;
    /**
     * The Speed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Speed;
    /**
     * The PositionDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PositionDateTime;
    /**
     * The LastMovement
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastMovement;
    /**
     * The PositionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PositionID;
    /**
     * The Kilometers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Kilometers;
    /**
     * The PositionCounter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PositionCounter;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * The BatteryStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BatteryStatus
     */
    public $BatteryStatus;
    /**
     * The PositionSource
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PositionSource;
    /**
     * The OperationMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OperationMode;
    /**
     * The ContactStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactStatus
     */
    public $ContactStatus;
    /**
     * The Temperatures
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Temperatures
     */
    public $Temperatures;
    /**
     * Constructor method for MagellanTracerPositionInfo_V2
     * @uses MagellanTracerPositionInfo_V2::setDirection()
     * @uses MagellanTracerPositionInfo_V2::setSpeed()
     * @uses MagellanTracerPositionInfo_V2::setPositionDateTime()
     * @uses MagellanTracerPositionInfo_V2::setLastMovement()
     * @uses MagellanTracerPositionInfo_V2::setPositionID()
     * @uses MagellanTracerPositionInfo_V2::setKilometers()
     * @uses MagellanTracerPositionInfo_V2::setPositionCounter()
     * @uses MagellanTracerPositionInfo_V2::setPosition()
     * @uses MagellanTracerPositionInfo_V2::setBatteryStatus()
     * @uses MagellanTracerPositionInfo_V2::setPositionSource()
     * @uses MagellanTracerPositionInfo_V2::setOperationMode()
     * @uses MagellanTracerPositionInfo_V2::setContactStatus()
     * @uses MagellanTracerPositionInfo_V2::setTemperatures()
     * @param int $direction
     * @param int $speed
     * @param string $positionDateTime
     * @param string $lastMovement
     * @param int $positionID
     * @param int $kilometers
     * @param int $positionCounter
     * @param \StructType\Position $position
     * @param \StructType\BatteryStatus $batteryStatus
     * @param string $positionSource
     * @param string $operationMode
     * @param \StructType\ContactStatus $contactStatus
     * @param \StructType\Temperatures $temperatures
     */
    public function __construct($direction = null, $speed = null, $positionDateTime = null, $lastMovement = null, $positionID = null, $kilometers = null, $positionCounter = null, \StructType\Position $position = null, \StructType\BatteryStatus $batteryStatus = null, $positionSource = null, $operationMode = null, \StructType\ContactStatus $contactStatus = null, \StructType\Temperatures $temperatures = null)
    {
        $this
            ->setDirection($direction)
            ->setSpeed($speed)
            ->setPositionDateTime($positionDateTime)
            ->setLastMovement($lastMovement)
            ->setPositionID($positionID)
            ->setKilometers($kilometers)
            ->setPositionCounter($positionCounter)
            ->setPosition($position)
            ->setBatteryStatus($batteryStatus)
            ->setPositionSource($positionSource)
            ->setOperationMode($operationMode)
            ->setContactStatus($contactStatus)
            ->setTemperatures($temperatures);
    }
    /**
     * Get Direction value
     * @return int
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @param int $direction
     * @return \StructType\MagellanTracerPositionInfo_V2
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: int
        if (!is_null($direction) && !(is_int($direction) || ctype_digit($direction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($direction, true), gettype($direction)), __LINE__);
        }
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get Speed value
     * @return int
     */
    public function getSpeed()
    {
        return $this->Speed;
    }
    /**
     * Set Speed value
     * @param int $speed
     * @return \StructType\MagellanTracerPositionInfo_V2
     */
    public function setSpeed($speed = null)
    {
        // validation for constraint: int
        if (!is_null($speed) && !(is_int($speed) || ctype_digit($speed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($speed, true), gettype($speed)), __LINE__);
        }
        $this->Speed = $speed;
        return $this;
    }
    /**
     * Get PositionDateTime value
     * @return string
     */
    public function getPositionDateTime()
    {
        return $this->PositionDateTime;
    }
    /**
     * Set PositionDateTime value
     * @param string $positionDateTime
     * @return \StructType\MagellanTracerPositionInfo_V2
     */
    public function setPositionDateTime($positionDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($positionDateTime) && !is_string($positionDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($positionDateTime, true), gettype($positionDateTime)), __LINE__);
        }
        $this->PositionDateTime = $positionDateTime;
        return $this;
    }
    /**
     * Get LastMovement value
     * @return string
     */
    public function getLastMovement()
    {
        return $this->LastMovement;
    }
    /**
     * Set LastMovement value
     * @param string $lastMovement
     * @return \StructType\MagellanTracerPositionInfo_V2
     */
    public function setLastMovement($lastMovement = null)
    {
        // validation for constraint: string
        if (!is_null($lastMovement) && !is_string($lastMovement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastMovement, true), gettype($lastMovement)), __LINE__);
        }
        $this->LastMovement = $lastMovement;
        return $this;
    }
    /**
     * Get PositionID value
     * @return int
     */
    public function getPositionID()
    {
        return $this->PositionID;
    }
    /**
     * Set PositionID value
     * @param int $positionID
     * @return \StructType\MagellanTracerPositionInfo_V2
     */
    public function setPositionID($positionID = null)
    {
        // validation for constraint: int
        if (!is_null($positionID) && !(is_int($positionID) || ctype_digit($positionID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($positionID, true), gettype($positionID)), __LINE__);
        }
        $this->PositionID = $positionID;
        return $this;
    }
    /**
     * Get Kilometers value
     * @return int
     */
    public function getKilometers()
    {
        return $this->Kilometers;
    }
    /**
     * Set Kilometers value
     * @param int $kilometers
     * @return \StructType\MagellanTracerPositionInfo_V2
     */
    public function setKilometers($kilometers = null)
    {
        // validation for constraint: int
        if (!is_null($kilometers) && !(is_int($kilometers) || ctype_digit($kilometers))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kilometers, true), gettype($kilometers)), __LINE__);
        }
        $this->Kilometers = $kilometers;
        return $this;
    }
    /**
     * Get PositionCounter value
     * @return int
     */
    public function getPositionCounter()
    {
        return $this->PositionCounter;
    }
    /**
     * Set PositionCounter value
     * @param int $positionCounter
     * @return \StructType\MagellanTracerPositionInfo_V2
     */
    public function setPositionCounter($positionCounter = null)
    {
        // validation for constraint: int
        if (!is_null($positionCounter) && !(is_int($positionCounter) || ctype_digit($positionCounter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($positionCounter, true), gettype($positionCounter)), __LINE__);
        }
        $this->PositionCounter = $positionCounter;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\MagellanTracerPositionInfo_V2
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get BatteryStatus value
     * @return \StructType\BatteryStatus|null
     */
    public function getBatteryStatus()
    {
        return $this->BatteryStatus;
    }
    /**
     * Set BatteryStatus value
     * @param \StructType\BatteryStatus $batteryStatus
     * @return \StructType\MagellanTracerPositionInfo_V2
     */
    public function setBatteryStatus(\StructType\BatteryStatus $batteryStatus = null)
    {
        $this->BatteryStatus = $batteryStatus;
        return $this;
    }
    /**
     * Get PositionSource value
     * @return string|null
     */
    public function getPositionSource()
    {
        return $this->PositionSource;
    }
    /**
     * Set PositionSource value
     * @param string $positionSource
     * @return \StructType\MagellanTracerPositionInfo_V2
     */
    public function setPositionSource($positionSource = null)
    {
        // validation for constraint: string
        if (!is_null($positionSource) && !is_string($positionSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($positionSource, true), gettype($positionSource)), __LINE__);
        }
        $this->PositionSource = $positionSource;
        return $this;
    }
    /**
     * Get OperationMode value
     * @return string|null
     */
    public function getOperationMode()
    {
        return $this->OperationMode;
    }
    /**
     * Set OperationMode value
     * @param string $operationMode
     * @return \StructType\MagellanTracerPositionInfo_V2
     */
    public function setOperationMode($operationMode = null)
    {
        // validation for constraint: string
        if (!is_null($operationMode) && !is_string($operationMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationMode, true), gettype($operationMode)), __LINE__);
        }
        $this->OperationMode = $operationMode;
        return $this;
    }
    /**
     * Get ContactStatus value
     * @return \StructType\ContactStatus|null
     */
    public function getContactStatus()
    {
        return $this->ContactStatus;
    }
    /**
     * Set ContactStatus value
     * @param \StructType\ContactStatus $contactStatus
     * @return \StructType\MagellanTracerPositionInfo_V2
     */
    public function setContactStatus(\StructType\ContactStatus $contactStatus = null)
    {
        $this->ContactStatus = $contactStatus;
        return $this;
    }
    /**
     * Get Temperatures value
     * @return \StructType\Temperatures|null
     */
    public function getTemperatures()
    {
        return $this->Temperatures;
    }
    /**
     * Set Temperatures value
     * @param \StructType\Temperatures $temperatures
     * @return \StructType\MagellanTracerPositionInfo_V2
     */
    public function setTemperatures(\StructType\Temperatures $temperatures = null)
    {
        $this->Temperatures = $temperatures;
        return $this;
    }
}
