<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LastPlace StructType
 * @subpackage Structs
 */
class LastPlace extends AbstractStructBase
{
    /**
     * The StartTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartTime;
    /**
     * The StopTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StopTime;
    /**
     * The PlaceStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PlaceStatus;
    /**
     * The PlaceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PlaceID;
    /**
     * The DriverDisplay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverDisplay;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * Constructor method for LastPlace
     * @uses LastPlace::setStartTime()
     * @uses LastPlace::setStopTime()
     * @uses LastPlace::setPlaceStatus()
     * @uses LastPlace::setPlaceID()
     * @uses LastPlace::setDriverDisplay()
     * @uses LastPlace::setStatus()
     * @param string $startTime
     * @param string $stopTime
     * @param string $placeStatus
     * @param string $placeID
     * @param string $driverDisplay
     * @param string $status
     */
    public function __construct($startTime = null, $stopTime = null, $placeStatus = null, $placeID = null, $driverDisplay = null, $status = null)
    {
        $this
            ->setStartTime($startTime)
            ->setStopTime($stopTime)
            ->setPlaceStatus($placeStatus)
            ->setPlaceID($placeID)
            ->setDriverDisplay($driverDisplay)
            ->setStatus($status);
    }
    /**
     * Get StartTime value
     * @return string
     */
    public function getStartTime()
    {
        return $this->StartTime;
    }
    /**
     * Set StartTime value
     * @param string $startTime
     * @return \StructType\LastPlace
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startTime, true), gettype($startTime)), __LINE__);
        }
        $this->StartTime = $startTime;
        return $this;
    }
    /**
     * Get StopTime value
     * @return string
     */
    public function getStopTime()
    {
        return $this->StopTime;
    }
    /**
     * Set StopTime value
     * @param string $stopTime
     * @return \StructType\LastPlace
     */
    public function setStopTime($stopTime = null)
    {
        // validation for constraint: string
        if (!is_null($stopTime) && !is_string($stopTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stopTime, true), gettype($stopTime)), __LINE__);
        }
        $this->StopTime = $stopTime;
        return $this;
    }
    /**
     * Get PlaceStatus value
     * @return string
     */
    public function getPlaceStatus()
    {
        return $this->PlaceStatus;
    }
    /**
     * Set PlaceStatus value
     * @uses \EnumType\EnumPlaceStatus::valueIsValid()
     * @uses \EnumType\EnumPlaceStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $placeStatus
     * @return \StructType\LastPlace
     */
    public function setPlaceStatus($placeStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumPlaceStatus::valueIsValid($placeStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumPlaceStatus', is_array($placeStatus) ? implode(', ', $placeStatus) : var_export($placeStatus, true), implode(', ', \EnumType\EnumPlaceStatus::getValidValues())), __LINE__);
        }
        $this->PlaceStatus = $placeStatus;
        return $this;
    }
    /**
     * Get PlaceID value
     * @return string|null
     */
    public function getPlaceID()
    {
        return $this->PlaceID;
    }
    /**
     * Set PlaceID value
     * @param string $placeID
     * @return \StructType\LastPlace
     */
    public function setPlaceID($placeID = null)
    {
        // validation for constraint: string
        if (!is_null($placeID) && !is_string($placeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($placeID, true), gettype($placeID)), __LINE__);
        }
        $this->PlaceID = $placeID;
        return $this;
    }
    /**
     * Get DriverDisplay value
     * @return string|null
     */
    public function getDriverDisplay()
    {
        return $this->DriverDisplay;
    }
    /**
     * Set DriverDisplay value
     * @param string $driverDisplay
     * @return \StructType\LastPlace
     */
    public function setDriverDisplay($driverDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($driverDisplay) && !is_string($driverDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverDisplay, true), gettype($driverDisplay)), __LINE__);
        }
        $this->DriverDisplay = $driverDisplay;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\LastPlace
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
}
