<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterfaceTachoCardInfoUpdate StructType
 * @subpackage Structs
 */
class InterfaceTachoCardInfoUpdate extends AbstractStructBase
{
    /**
     * The TachoLoginEnabled
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $TachoLoginEnabled;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExpirationDate;
    /**
     * The CardId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardId;
    /**
     * The CountryOfIssueCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryOfIssueCode;
    /**
     * Constructor method for InterfaceTachoCardInfoUpdate
     * @uses InterfaceTachoCardInfoUpdate::setTachoLoginEnabled()
     * @uses InterfaceTachoCardInfoUpdate::setExpirationDate()
     * @uses InterfaceTachoCardInfoUpdate::setCardId()
     * @uses InterfaceTachoCardInfoUpdate::setCountryOfIssueCode()
     * @param bool $tachoLoginEnabled
     * @param string $expirationDate
     * @param string $cardId
     * @param string $countryOfIssueCode
     */
    public function __construct($tachoLoginEnabled = null, $expirationDate = null, $cardId = null, $countryOfIssueCode = null)
    {
        $this
            ->setTachoLoginEnabled($tachoLoginEnabled)
            ->setExpirationDate($expirationDate)
            ->setCardId($cardId)
            ->setCountryOfIssueCode($countryOfIssueCode);
    }
    /**
     * Get TachoLoginEnabled value
     * @return bool
     */
    public function getTachoLoginEnabled()
    {
        return $this->TachoLoginEnabled;
    }
    /**
     * Set TachoLoginEnabled value
     * @param bool $tachoLoginEnabled
     * @return \StructType\InterfaceTachoCardInfoUpdate
     */
    public function setTachoLoginEnabled($tachoLoginEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($tachoLoginEnabled) && !is_bool($tachoLoginEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tachoLoginEnabled, true), gettype($tachoLoginEnabled)), __LINE__);
        }
        $this->TachoLoginEnabled = $tachoLoginEnabled;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return string
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \StructType\InterfaceTachoCardInfoUpdate
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get CardId value
     * @return string|null
     */
    public function getCardId()
    {
        return $this->CardId;
    }
    /**
     * Set CardId value
     * @param string $cardId
     * @return \StructType\InterfaceTachoCardInfoUpdate
     */
    public function setCardId($cardId = null)
    {
        // validation for constraint: string
        if (!is_null($cardId) && !is_string($cardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardId, true), gettype($cardId)), __LINE__);
        }
        $this->CardId = $cardId;
        return $this;
    }
    /**
     * Get CountryOfIssueCode value
     * @return string|null
     */
    public function getCountryOfIssueCode()
    {
        return $this->CountryOfIssueCode;
    }
    /**
     * Set CountryOfIssueCode value
     * @param string $countryOfIssueCode
     * @return \StructType\InterfaceTachoCardInfoUpdate
     */
    public function setCountryOfIssueCode($countryOfIssueCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryOfIssueCode) && !is_string($countryOfIssueCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryOfIssueCode, true), gettype($countryOfIssueCode)), __LINE__);
        }
        $this->CountryOfIssueCode = $countryOfIssueCode;
        return $this;
    }
}
