<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterfaceGeoFenceUpdate_V2 StructType
 * @subpackage Structs
 */
class InterfaceGeoFenceUpdate_V2 extends InterfaceGeoFenceInsert_V2
{
    /**
     * The GeoZoneUpdateType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GeoZoneUpdateType;
    /**
     * The GeoFence
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierGeoFence
     */
    public $GeoFence;
    /**
     * Constructor method for InterfaceGeoFenceUpdate_V2
     * @uses InterfaceGeoFenceUpdate_V2::setGeoZoneUpdateType()
     * @uses InterfaceGeoFenceUpdate_V2::setGeoFence()
     * @param string $geoZoneUpdateType
     * @param \StructType\IdentifierGeoFence $geoFence
     */
    public function __construct($geoZoneUpdateType = null, \StructType\IdentifierGeoFence $geoFence = null)
    {
        $this
            ->setGeoZoneUpdateType($geoZoneUpdateType)
            ->setGeoFence($geoFence);
    }
    /**
     * Get GeoZoneUpdateType value
     * @return string
     */
    public function getGeoZoneUpdateType()
    {
        return $this->GeoZoneUpdateType;
    }
    /**
     * Set GeoZoneUpdateType value
     * @uses \EnumType\EnumGeoZoneUpdateType::valueIsValid()
     * @uses \EnumType\EnumGeoZoneUpdateType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geoZoneUpdateType
     * @return \StructType\InterfaceGeoFenceUpdate_V2
     */
    public function setGeoZoneUpdateType($geoZoneUpdateType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumGeoZoneUpdateType::valueIsValid($geoZoneUpdateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumGeoZoneUpdateType', is_array($geoZoneUpdateType) ? implode(', ', $geoZoneUpdateType) : var_export($geoZoneUpdateType, true), implode(', ', \EnumType\EnumGeoZoneUpdateType::getValidValues())), __LINE__);
        }
        $this->GeoZoneUpdateType = $geoZoneUpdateType;
        return $this;
    }
    /**
     * Get GeoFence value
     * @return \StructType\IdentifierGeoFence|null
     */
    public function getGeoFence()
    {
        return $this->GeoFence;
    }
    /**
     * Set GeoFence value
     * @param \StructType\IdentifierGeoFence $geoFence
     * @return \StructType\InterfaceGeoFenceUpdate_V2
     */
    public function setGeoFence(\StructType\IdentifierGeoFence $geoFence = null)
    {
        $this->GeoFence = $geoFence;
        return $this;
    }
}
