<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsertGeoFenceResult StructType
 * @subpackage Structs
 */
class InsertGeoFenceResult extends ExecutionResult
{
    /**
     * The GeoFenceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GeoFenceID;
    /**
     * The GeoFenceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GeoFenceName;
    /**
     * The GeoZones
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInsertGeoZoneResult
     */
    public $GeoZones;
    /**
     * Constructor method for InsertGeoFenceResult
     * @uses InsertGeoFenceResult::setGeoFenceID()
     * @uses InsertGeoFenceResult::setGeoFenceName()
     * @uses InsertGeoFenceResult::setGeoZones()
     * @param int $geoFenceID
     * @param string $geoFenceName
     * @param \ArrayType\ArrayOfInsertGeoZoneResult $geoZones
     */
    public function __construct($geoFenceID = null, $geoFenceName = null, \ArrayType\ArrayOfInsertGeoZoneResult $geoZones = null)
    {
        $this
            ->setGeoFenceID($geoFenceID)
            ->setGeoFenceName($geoFenceName)
            ->setGeoZones($geoZones);
    }
    /**
     * Get GeoFenceID value
     * @return int
     */
    public function getGeoFenceID()
    {
        return $this->GeoFenceID;
    }
    /**
     * Set GeoFenceID value
     * @param int $geoFenceID
     * @return \StructType\InsertGeoFenceResult
     */
    public function setGeoFenceID($geoFenceID = null)
    {
        // validation for constraint: int
        if (!is_null($geoFenceID) && !(is_int($geoFenceID) || ctype_digit($geoFenceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($geoFenceID, true), gettype($geoFenceID)), __LINE__);
        }
        $this->GeoFenceID = $geoFenceID;
        return $this;
    }
    /**
     * Get GeoFenceName value
     * @return string|null
     */
    public function getGeoFenceName()
    {
        return $this->GeoFenceName;
    }
    /**
     * Set GeoFenceName value
     * @param string $geoFenceName
     * @return \StructType\InsertGeoFenceResult
     */
    public function setGeoFenceName($geoFenceName = null)
    {
        // validation for constraint: string
        if (!is_null($geoFenceName) && !is_string($geoFenceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geoFenceName, true), gettype($geoFenceName)), __LINE__);
        }
        $this->GeoFenceName = $geoFenceName;
        return $this;
    }
    /**
     * Get GeoZones value
     * @return \ArrayType\ArrayOfInsertGeoZoneResult|null
     */
    public function getGeoZones()
    {
        return $this->GeoZones;
    }
    /**
     * Set GeoZones value
     * @param \ArrayType\ArrayOfInsertGeoZoneResult $geoZones
     * @return \StructType\InsertGeoFenceResult
     */
    public function setGeoZones(\ArrayType\ArrayOfInsertGeoZoneResult $geoZones = null)
    {
        $this->GeoZones = $geoZones;
        return $this;
    }
}
